% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cepp.weights.R
\name{cepp.weights}
\alias{cepp.weights}
\title{Compute region weights for \code{cepp.test}}
\usage{
cepp.weights(nn, pop, nstar)
}
\arguments{
\item{nn}{A list of nearest neighbors produced by
\code{\link{casewin}}.}

\item{pop}{The population size associated with each
region.}

\item{nstar}{The size of the at-risk population
in each window.}
}
\value{
A list with elements related to the weight
each nearest neighbor region will have in the
corresponding weighted sum used to compute the test
statistic
}
\description{
Compute region weights for \code{cepp.test}
}
\examples{
data(nydf)
coords = with(nydf, cbind(x, y))
pop = nydf$pop
# intercentroid distances
d = sp::spDists(coords)
# find smallest windows with cumulative population of
# at least n* = 1000
nn = casewin(d, pop, 1000)
# compute weights
w = cepp.weights(nn, pop, 1000)
}
