% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rflex.midp.R
\name{rflex.midp}
\alias{rflex.midp}
\title{Compute middle p-value}
\usage{
rflex.midp(cases, ex, type = "poisson", pop = NULL)
}
\arguments{
\item{cases}{The number of cases observed in each region.}

\item{ex}{The expected number of cases for each region.
The default is calculated under the constant risk
hypothesis.}

\item{type}{The type of scan statistic to compute. The
default is \code{"poisson"}. The other choice
is \code{"binomial"}.}

\item{pop}{The population size associated with each
region.}
}
\value{
A vector of middle p-values
}
\description{
Computes P(Y > cases) + P(Y = cases)/2 when Y ~
Poisson(ex) or Y ~ Binomial(n = pop, p = ex/pop).  This
is middle p-value computed by Tango and Takahashi (2012).
}
\examples{
data(nydf)
cases = floor(nydf$cases)
pop = nydf$pop
ex = pop * sum(cases)/sum(pop)
# zones for poisson model
pp = rflex.midp(cases, ex)
# zones for binomial model
bp = rflex.midp(cases, ex, type = "binomial", pop = pop)
}
\references{
Tango, T. and Takahashi, K. (2012), A
  flexible spatial scan statistic with a restricted
  likelihood ratio for detecting disease clusters.
  Statist. Med., 31: 4207-4218. <doi:10.1002/sim.5478>
}
\author{
Joshua French
}
