% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmst.zones.R
\name{dmst.zones}
\alias{dmst.zones}
\title{Determine zones for the Dynamic Minimum Spanning Tree scan test}
\usage{
dmst.zones(
  coords,
  cases,
  pop,
  w,
  ex = sum(cases)/sum(pop) * pop,
  ubpop = 0.5,
  ubd = 1,
  longlat = FALSE,
  cl = NULL,
  progress = TRUE
)
}
\arguments{
\item{coords}{An \eqn{n \times 2} matrix of centroid
coordinates for the regions in the form (x, y) or
(longitude, latitude) is using great circle distance.}

\item{cases}{The number of cases observed in each region.}

\item{pop}{The population size associated with each
region.}

\item{w}{A binary spatial adjacency matrix for the
regions.}

\item{ex}{The expected number of cases for each region.
The default is calculated under the constant risk
hypothesis.}

\item{ubpop}{The upperbound of the proportion of the
total population to consider for a cluster.}

\item{ubd}{A proportion in (0, 1].  The distance of
potential clusters must be no more than \code{ubd * m},
where \code{m} is the maximum intercentroid distance
between all coordinates.}

\item{longlat}{The default is \code{FALSE}, which
specifies that Euclidean distance should be used. If
\code{longlat} is \code{TRUE}, then the great circle
distance is used to calculate the intercentroid
distance.}

\item{cl}{
A cluster object created by \code{\link{makeCluster}},
or an integer to indicate number of child-processes
(integer values are ignored on Windows) for parallel evaluations
(see Details on performance).
}

\item{progress}{A logical value indicating whether a
progress bar should be displayed.  The default is
\code{TRUE}.}
}
\value{
Returns a list with elements: \item{zones}{A list
  contained the location ids of each potential cluster.}
  \item{loglikrat}{The loglikelihood ratio for each zone
  (i.e., the log of the test statistic).}
  \item{cases}{The observed number of cases in each
  zone.} \item{expected}{The expected number of cases
  each zone.} \item{pop}{The total population in each
  zone.}
}
\description{
\code{dmst.zones} determines the zones for the Dynamic
Minimum Spanning Tree scan test (\code{\link{dmst.test}}).  The
function returns the zones, as well as the associated
test statistic, cases in each zone, the expected number
of cases in each zone, and the population in each zone.
}
\details{
Every zone considered must have a total population less
than \code{ubpop * sum(pop)}.  Additionally, the maximum
intercentroid distance for the regions within a zone must
be no more than \code{ubd * the maximum intercentroid
distance across all regions}.
}
\examples{
data(nydf)
data(nyw)
coords <- as.matrix(nydf[, c("longitude", "latitude")])
# find zone with max statistic starting from each individual region
all_zones <- dmst.zones(coords,
  cases = floor(nydf$cases),
  nydf$pop, w = nyw, ubpop = 0.25,
  ubd = .25, longlat = TRUE
)
}
\references{
Assuncao, R.M., Costa, M.A., Tavares, A. and
  Neto, S.J.F. (2006). Fast detection of arbitrarily
  shaped disease clusters, Statistics in Medicine, 25,
  723-742.  <doi:10.1002/sim.2411>
}
\author{
Joshua French
}
