% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{prox}
\alias{prox}
\title{Composite proximal operator based on L2, L2-Square, and L1 penalties}
\usage{
prox(x, lambda, hierarchy, d)
}
\arguments{
\item{x}{A numeric vector of two.}

\item{lambda}{a vector of three penalty parameters. \eqn{\lambda_1} and 
\eqn{\lambda_2} are L2 and L2-Square (ridge) penalties for \eqn{x} in 
a group level, and \eqn{\lambda_3} is the L1 penalty for \eqn{x_2}, respectively.}

\item{hierarchy}{a factor value in levels 0, 1, 2, which represent different
hierarchical structure in x, respectively. When \code{hierarchy=0},
\eqn{\lambda_2} and \eqn{\lambda_3} are forced to be zeroes; when
\code{hierarchy=1}, \eqn{\lambda_2} is forced to be zero; when 
\code{hierarchy=2}, there is no constraint on \eqn{\lambda}'s. 
See \code{\link{smog}}.}

\item{d}{indices for overlapped variables in x.}
}
\value{
A two-dimensional numerical vector, soft-thresholded based on a composition of 
        \eqn{\lambda_1}, \eqn{\lambda_2}, and \eqn{\lambda_3}.
}
\description{
Composite proximal operator based on L2, L2-Square, and L1 penalties
}
\examples{
prox(x = rnorm(6,2,1), lambda = c(0.5,0.3,0.1), hierarchy = 0, d = c(1,1,2,2,3,3))

}
\references{
\insertRef{ma2019structural}{smog}
}
\seealso{
\code{\link{cv.smog}}, \code{\link{smog.default}}, \code{\link{smog.formula}}, 
         \code{\link{predict.smog}}, \code{\link{plot.smog}}.
}
\author{
Chong Ma, \email{chongma8903@gmail.com}.
}
