% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sof.griewank.R
\name{makeGriewankFunction}
\alias{makeGriewankFunction}
\title{Griewank Function}
\usage{
makeGriewankFunction(dimensions)
}
\arguments{
\item{dimensions}{[\code{integer(1)}]\cr
Size of corresponding parameter space.}
}
\value{
[\code{smoof_single_objective_function}]
}
\description{
Highly multimodal function with a lot of regularly distributed local minima.
The corresponding formula is:
\deqn{f(\mathbf{x}) = \sum_{i=1}^{n} \frac{\mathbf{x}_i^2}{4000} - \prod_{i=1}^{n} \cos\left(\frac{\mathbf{x}_i}{\sqrt{i}}\right) + 1}
subject to \eqn{\mathbf{x}_i \in [-100, 100], i = 1, \ldots, n}.
}
\references{
A. O. Griewank, Generalized Descent for Global Optimization,
Journal of Optimization Theory and Applications, vol. 34, no. 1,
pp. 11-39, 1981.
}

