% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothic_functions.R
\name{plot_effects}
\alias{plot_effects}
\title{Plot conditional density curves}
\usage{
plot_effects(obj, what = "all", density_range)
}
\arguments{
\item{obj}{An object of class \dQuote{\code{smoothic}} which is the result
of a call to \code{\link{smoothic}}.}

\item{what}{The covariate effects to be plotted, default is \code{what = "all"}. The user
may supply a vector of covariate names to be plotted (only covariates selected in the final
model can be plotted). Additionally, a "baseline" or "average" individual can be plotted by
supplying \code{what = "median"}.}

\item{density_range}{Optional range for which the density curves should be plotted.}
}
\value{
A plot of the conditional density curves.
}
\description{
This function plots the model-based conditional density curves for
different effect combinations. For example, take a particular covariate that is selected
in the final model. The other selected covariates are fixed at their median values and then
the plotted red and blue densities correspond to the modification of the chosen
covariate as "low" (Q1, first quartile) and "high" (Q3, third quartile).
}
\examples{
# Sniffer Data --------------------
# MPR Model ----
results <- smoothic(
  formula = y ~ .,
  data = sniffer,
  family = "normal",
  model = "mpr"
)
plot_effects(results)

}
\author{
Meadhbh O'Neill
}
