% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smovie.R
\docType{package}
\name{smovie}
\alias{smovie}
\alias{smovie-package}
\title{smovie: some movies to illustrate concepts in statistics}
\description{
These movies are animations used to illustrate key statistical ideas.
They are produced using the \code{\link[rpanel:rpanel.package]{rpanel}}
package, which has
\href{https://sourceforge.net/projects/tcllib/files/BWidget/}{\code{BWidget}}
as a system requirement.
\code{BWidget} is included in the R installers for Windows and macOS.
For other platforms please see
\href{https://cran.r-project.org/doc/manuals/r-devel/R-exts.html#Non_002dR-scripts-in-packages}{Section 1.1.7 of Writing R Extensions}
for installation advice.
}
\details{
When one of these functions is called R opens up a small
\emph{parameter window} containing clickable buttons that can be
used to change parameters underlying the plot. For the effects of
these buttons see the documentation of the individual functions.

See \code{vignette("smovie-vignette", package = "smovie")} for an overview
of the package and the \link[=movies]{user-friendly menu panel}.

There are movies on the following topics.
}
\section{{Probability distributions}}{

\itemize{
  \item {\link[=discrete]{Discrete distributions}}
  \item {\link[=continuous]{Continuous distributions}}
}
}

\section{{Sampling distributions}}{

\itemize{
  \item {\link[=clt]{Central Limit Theorem: sampling distribution
    of a sample mean}}
  \item {\link[=clt]{Central Limit Theorem for sample quantiles: sampling
    distribution of the 100p\% sample quantile}}
  \item {\link[=mean_vs_median]{Sampling distributions of the mean
    and median}}
  \item {\link[=ett]{Extremal Types Theorem: sampling distribution
    of a sample maximum}}
  \item {\link[=correlation]{Pearson product moment correlation
    coefficient}}
}
}

\section{{Regression}}{

\itemize{
  \item {\link[=lev_inf]{Leverage and influence in simple linear
    regression}}
}
}

\section{{Hypothesis testing}}{

\itemize{
  \item {\link[=wws]{Wald, Wilks and Score tests}}
  \item {\link[=shypo]{Testing simple hypotheses}}
}
}

\references{
Bowman, A., Crawford, E., Alexander, G. and Bowman, R. W.
 (2007). rpanel: Simple Interactive Controls for R Functions Using the
 tcltk Package.  \emph{Journal of Statistical Software}, \strong{17(9)},
 1-18. \url{http://www.jstatsoft.org/v17/i09/}.
}
