\name{find_best_selection_SA}
\alias{find_best_selection_SA}
\title{find_best_selection_SA}
\usage{
  find_best_selection_SA(iterations, bhps, area_census,
    in.lexicon)
}
\arguments{
  \item{area_census}{A census dataset consisting of various
  areas rows.}

  \item{iterations}{The number of iterations}

  \item{bhps}{the panel dataset}

  \item{in.lexicon}{The data lexicon.}
}
\value{
  msm_results An object with the results of the simulation,
  of this area.
}
\description{
  Run a simulation in parallel mode with Simulated
  annealing
}
\examples{
library(sms)
#========================= Panel Data ============================
n=20
panel=data.frame(pid=6001:6020, he=sample(0:1,n,rep=TRUE),females=sample(0:1,n,rep=TRUE))
#========================= Census Data ============================
census=data.frame(areaid=c(101,102) , population=c(54,50), he=c(36,30), fem= c(24,27))
#========================= Data linkage ===========================
con_01=c("he","he" )
con_02=c("fem","females" )
in.lexicon=data.frame(con_01,con_02 )
row.names(in.lexicon)=c("census_row","panel_row")

this_area=as.data.frame(census[1,]) #Select the first area from the census table
iterations=70
myselection= find_best_selection_SA( iterations, panel, this_area, in.lexicon)
print(myselection)
}
\author{
  Dimitris Kavroudakis
}

