% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtable_associations.R
\name{ggplot_associations}
\alias{ggplot_associations}
\title{Ggplot associations}
\usage{
ggplot_associations(
  df_snp,
  pvalue_colname = "pvalues",
  labels_colname = "probe_id",
  n_labels = 10,
  nudge = c(0, 1),
  linked_area = FALSE,
  byindex = linked_area,
  colors = if (linked_area) snp_position_colors(nrow(df_snp)) else "black"
)
}
\arguments{
\item{df_snp}{SNP annotation data frame with columns chromosome,
position, and as specified by parameters pvalue_colname
and optionally labels_colname.}

\item{pvalue_colname}{Column name of df_snp with association values}

\item{labels_colname}{Optional column name of df_snp with labels.
Set to NULL to remove.}

\item{n_labels}{Number of labels of most associated points to display.}

\item{nudge}{Nudge parameter passed to ggrepel::geom_label_repel.}

\item{linked_area}{Add a linked area to associations points, default FALSE}

\item{byindex}{Display by SNP index or chromosomic position (default)}

\item{colors}{Colors of SNPs}
}
\value{
ggplot
}
\description{
Get SNPs associations ggplot, either as points or as a linked area.
Optionally add labels to most associated points using ggrepel.
}
