% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snpset_test.R
\name{snpset_test}
\alias{snpset_test}
\title{Set-based association tests}
\usage{
snpset_test(hsumstats, x, snp_sets, method = c("saddle", "davies"))
}
\arguments{
\item{hsumstats}{A data frame processed by \code{\link{harmonize_sumstats}}.}

\item{x}{A \code{bed.matrix} object created from the reference data.}

\item{snp_sets}{A named list where each index represents a separate set of
SNPs.}

\item{method}{A method to compute a set-level p value. "saddle" uses
Kuonen's saddlepoint approximation (1999) and "davies" uses the algorithm
of Davies (1980). When "davies" method failed to produce a meaningful
result, "saddle" method is used as a fallback. Default is "saddle".}
}
\value{
A data.table with columns: "set.id", "pvalue", "n.snp", "top.snp.id"
and "top.snp.pvalue"
\itemize{
\item set.id = a name of SNP set
\item tstat = a test statistic
\item pvalue = a set-level p value
\item n.snp = the number of SNPs used in a test
\item top.snp.id = SNP ID with the smallest p-value within a set of SNPs
\item top.snp.pvalue = The smallest p-value within a set of SNPs
}
}
\description{
Perform set-based association tests between multiple sets of SNPs and a
phenotype using GWAS summary statistics. If the function encounters missing
genotypes in the reference data, they will be imputed with genotype means.
}
\examples{
## GWAS summary statistics
head(exGWAS)

## Load reference genotype data
bfile <- system.file("extdata", "example.bed", package = "snpsettest")
x <- read_reference_bed(path = bfile)

## GWAS harmonization with reference data
hsumstats <- harmonize_sumstats(exGWAS, x)

## Perform a set-based test with an arbitrary SNP set
snpset_test(hsumstats, x, list(test = c("SNP_880", "SNP_1533", "SNP_4189")))

## Gene information data
head(gene.curated.GRCh37)

## Map SNPs to genes
snp_sets <- map_snp_to_gene(hsumstats, gene.curated.GRCh37)

## Perform gene-based association tests
\donttest{out <- snpset_test(hsumstats, x, snp_sets$sets)}

}
\references{
Kuonen, D. Saddlepoint Approximations for Distributions of Quadratic Forms
in Normal Variables. Biometrika 86, 929–935 (1999).

Davies, R. B. Algorithm AS 155: The Distribution of a Linear Combination of
Chi-Square Random Variables. Journal of the Royal Statistical Society.
Series C (Applied Statistics) 29, 323–333 (1980).
}
