% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/functions_ellipse.r
\name{map.ellipse}
\alias{map.ellipse}
\title{Concentration ellipses}
\usage{
map.ellipse(object, ca.plot = map.ind(object), variable,
  ellipse.label = TRUE, ellipse.color = "default", label.size = 4,
  draw.levels = 1:nlevels(variable), ellipse.line = "solid")
}
\arguments{
\item{object}{is a \link{soc.ca} class object.}

\item{ca.plot}{is a plot made from a \link{soc.ca} object.}

\item{variable}{is a factor of the same length and in the same order as the
active varibles used for the \link{soc.ca} object.}

\item{ellipse.label}{if TRUE the labels are included in the map.}

\item{ellipse.color}{defines the color of the ellipses. If "default" the globally defined default colors are used. Ellipse.color can be either length of 1 or equal to the number of drawn levels.}

\item{label.size}{defines the size of the labels.}

\item{draw.levels}{indicates the levels in the variable for which a ellipse is drawn.}

\item{ellipse.line}{defines the type of line used for the ellipses.}
}
\value{
a plot with a concentration ellipse containing 80\% of the
  individuals for each modality.
}
\description{
Add ellipses for each level in a factor to a plot made from a \link{soc.ca}
object.
}
\examples{
example(soc.ca)
map <- map.ind(result)
map.ellipse(result, map, active[,2])
}
\seealso{
\link{map.ind}, \link{map.ctr}
}

