% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_plot.r
\name{map.path}
\alias{map.path}
\title{Map path along an ordered variable}
\usage{
map.path(
  object,
  x,
  map = map.ind(object, dim),
  dim = c(1, 2),
  label = TRUE,
  min.size = length(x)/10,
  ...
)
}
\arguments{
\item{object}{is a soc.ca result object}

\item{x}{is an ordered vector, either numerical or factor}

\item{map}{is a plot object created with one of the mapping functions in the 
soc.ca package}

\item{dim}{the dimensions in the order they are to be plotted. The first 
number defines the horizontal axis and the second number defines the 
vertical axis.}

\item{label}{if TRUE the label of the points are shown}

\item{min.size}{is the minimum size given to the groups of a numerical 
variable, see \link{min_cut}.}

\item{...}{further arguments are passed onto \link{geom_path},
\link{geom_point} and \link{geom_text} from the ggplot2 package}
}
\description{
Plot a path along an ordered variable. If the variable is numerical it is cut
into groups by the \link{min_cut} function.
}
\examples{
example(soc.ca)
map <- map.ind(result, point.color = as.numeric(sup$Age))
map <- map + scale_color_continuous(high = "red", low = "yellow")
map.path(result, sup$Age, map)
}
