% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copeland.R
\name{copelandScores}
\alias{copelandScores}
\alias{copelandRanking}
\title{Copeland-like method}
\usage{
copelandScores(powerRelation, elements = powerRelation$elements)

copelandRanking(powerRelation)
}
\arguments{
\item{powerRelation}{A \code{\link{PowerRelation}} object created by \code{\link[=PowerRelation]{PowerRelation()}} or \code{\link[=as.PowerRelation]{as.PowerRelation()}}}

\item{elements}{Vector of elements of which to calculate their scores.
By default, the scores of all elements in \code{powerRelation$elements} are considered.}
}
\value{
Score function returns a list of type \code{CopelandScores} and length of \code{powerRelation$elements}
(unless parameter \code{elements} is specified). Each element is a vector of 2 numbers,
the number of pairwise winning comparisons and the number of pairwise losing comparisons.
Those two numbers summed together gives us the actual ordinal Copeland score.

Ranking function returns corresponding \code{\link{SocialRanking}} object.
}
\description{
Based on \code{\link[=cpMajorityComparison]{cpMajorityComparison()}}, add or subtract scores
based on how an element fares against the others.

\code{copelandRanking()} returns the corresponding ranking.
}
\details{
Strongly inspired by the Copeland score of social choice theory \insertCite{1951Copeland}{socialranking},
the Copeland-like solution is based on the net flow of the CP-majority graph \insertCite{2021Manipulability}{socialranking}.

Individuals are ordered according to the number of pairwise winning comparisons, minus the number of pairwise losing comparisons,
over the set of all CP-comparisons.

More formally, in a given \verb{PowerRelation pr} with element \eqn{i}{i}, count the number of elements
\eqn{j \in N \setminus \lbrace i \rbrace}{j in N - \{i\}} where
\code{\link{cpMajorityComparison}}\verb{(pr, i, j) >= 0} and subtract those where
\code{\link{cpMajorityComparison}}\verb{(pr, i, j) <= 0}.
}
\examples{
# (123 ~ 12 ~ 3 ~ 1) > (2 ~ 23) > 13
pr <- PowerRelation(list(
  list(c(1,2,3), c(1,2), 3, 1),
  list(c(2,3), 2),
  list(c(1,3))
))

copelandScores(pr)
# `1` = c(2, -1)
# `2` = c(2, -2)
# `3` = c(1, -2)

# only calculate results for two elements
copelandScores(pr, c(1,3))
# `1` = c(2, -1)
# `3` = c(1, -2)

# or just one element
copelandScores(pr, 2)
# `2` = c(2, -2)

# 1 > 2 > 3
copelandRanking(pr)

}
\references{
\insertRef{2021Manipulability}{socialranking}

\insertRef{1951Copeland}{socialranking}
}
\seealso{
Other CP-majority based functions: 
\code{\link{cpMajorityComparison}()},
\code{\link{kramerSimpsonScores}()}

Other ranking solution functions: 
\code{\link{L1Scores}()},
\code{\link{L2Scores}()},
\code{\link{LPSScores}()},
\code{\link{LPScores}()},
\code{\link{cumulativeScores}()},
\code{\link{kramerSimpsonScores}()},
\code{\link{lexcelScores}()},
\code{\link{ordinalBanzhafScores}()}
}
\concept{CP-majority based functions}
\concept{ranking solution functions}
