% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/utilities.R
\name{Sodium utilities}
\alias{Sodium utilities}
\alias{bin2hex}
\alias{helpers}
\alias{hex2bin}
\alias{random}
\title{Sodium Utilities}
\usage{
bin2hex(bin)

hex2bin(hex, ignore = ":")

random(n = 1)
}
\arguments{
\item{bin}{raw vector with binary data to convert to hex string}

\item{hex}{a string with hexadecimal characters to parse into a binary (raw) vector.}

\item{ignore}{a string with characters to ignore from \code{hex}. See example.}

\item{n}{number of random bytes or numbers to generate}
}
\description{
The functions \code{bin2hex} and \code{hex2bin} convert between binary (raw)
vectors and corresponding string in hexadecimal notation. The \code{random}
function generates \code{n} crypto secure random bytes.
}
\examples{
# Convert raw to hex string and back
test <- charToRaw("test 123")
x <- bin2hex(test)
y <- hex2bin(x)
stopifnot(identical(test, y))
stopifnot(identical(x, paste(test, collapse = "")))

# Parse text with characters
x2 <- paste(test, collapse = ":")
y2 <- hex2bin(x2, ignore = ":")
stopifnot(identical(test, y2))
}

