% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collection_addreplicaprop.R
\name{collection_addreplicaprop}
\alias{collection_addreplicaprop}
\title{Add a replica property}
\usage{
collection_addreplicaprop(name, shard, replica, property, property.value,
  shardUnique = FALSE, raw = FALSE, callopts = list())
}
\arguments{
\item{name}{(character) Required. The name of the collection this replica belongs to.}

\item{shard}{(character) Required. The name of the shard the replica belongs to.}

\item{replica}{(character) Required. The replica, e.g. core_node1.}

\item{property}{(character) Required. The property to add. Note: this will have the
literal 'property.' prepended to distinguish it from system-maintained properties.
So these two forms are equivalent: \code{property=special} and
\code{property=property.special}}

\item{property.value}{(character) Required. The value to assign to the property.}

\item{shardUnique}{(logical) If \code{TRUE}, then setting this property in one
replica will (1) remove the property from all other replicas in that shard.
Default: \code{FALSE}}

\item{raw}{(logical) If \code{TRUE}, returns raw data}

\item{callopts}{curl options passed on to \code{\link[httr]{GET}}}
}
\description{
Assign an arbitrary property to a particular replica and give it
the value specified. If the property already exists, it will be overwritten
with the new value.
}
\examples{
\dontrun{
solr_connect()

# create collection
collection_create(name = "addrep", numShards = 2) # bin/solr create -c addrep

# status
collection_clusterstatus()$cluster$collections$addrep$shards

# add the value world to the property hello
collection_addreplicaprop(name = "addrep", shard = "shard1", replica = "core_node1",
   property = "hello", property.value = "world")

# check status
collection_clusterstatus()$cluster$collections$addrep$shards
collection_clusterstatus()$cluster$collections$addrep$shards$shard1$replicas$core_node1
}
}

