% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beacon.R
\name{Beacon.create}
\alias{Beacon.create}
\title{Beacon.create}
\usage{
Beacon.create(beacon_set_id, vault_object_id, title,
  env = solvebio:::.solveEnv, ...)
}
\arguments{
\item{beacon_set_id}{The ID of the parent beacon set.}

\item{vault_object_id}{The ID of the vault object (i.e. dataset) queried by the beacon.}

\item{title}{The title displayed for the beacon.}

\item{env}{(optional) Custom client environment.}

\item{...}{(optional) Additional beacon attributes (such as description and params).}
}
\description{
Add a new beacon to an existing beacon set. The beacon set must already exist in order to add beacons.
}
\examples{
\dontrun{
Beacon.create(
              beacon_set_id="1234",
              vault_object_id="1234567890",
              title="My new beacon"
              )
}

}
\references{
\url{https://docs.solvebio.com/}
}
