\name{HDdata}
\alias{HDdata}
\docType{data}
\title{
half diallel data for corn hybrids
}
\description{
This dataset contains phenotpic data for 21 corn hybrids, with 2 technical repetitions, coming from a half diallel design and evaluated for sugar content. The column geno indicates the hybrid and male and female origin columns are included as well. Since there's 2 technical reps the error variance obtained by REML/ML has to be divided over 2. 

}
\usage{data("HDdata")}
\format{
  The format is:
 chr "HDdata"
}
\source{
This data was generated by a corn study.
}
\references{
Covarrubias-Pazaran G (2016) sommer: An R package for mixed model analysis education. R package version 1.1. URL https://cran.r-project.org/web/packages/sommer/.
}
\examples{
####=========================================####
#### For CRAN time limitations most lines in the 
#### examples are silenced with one '#' mark, 
#### remove them and run the examples
####=========================================####
data(HDdata)
head(HDdata)

####=========================================####
#### GCA matrix for half diallel using male and female columns
#### use the 'hdm' function to create the half diallel matrix
####=========================================####
Z1 <- hdm(HDdata[,c(3:4)])

####=========================================####
#### SCA matrix
####=========================================####
Z2 <- model.matrix(~as.factor(geno)-1, data=HDdata)

####=========================================####
#### Define response variable and run
####=========================================####
y <- HDdata$sugar
ETA <- list(list(Z=Z1), list(Z=Z2)) # Zu component
modHD <- mmer(y=y, Z=ETA)
summary(modHD)
}
\keyword{datasets}
