% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soo_function.R
\name{soo_function}
\alias{soo_function}
\title{Single Objective Optimization Function}
\usage{
soo_function(
  name,
  id,
  fun,
  dimensions,
  lower_bounds,
  upper_bounds,
  best_value,
  best_par
)
}
\arguments{
\item{name}{Name of function.}

\item{id}{Short id for the function. Must be unique to the
function instance and should not contain any other characters than
[a-z], [0-9] and \sQuote{-}.}

\item{fun}{Function definition.}

\item{dimensions}{Size of parameter space.}

\item{lower_bounds}{Lower bounds of the parameter space.}

\item{upper_bounds}{Upper bounds of the parameter space.}

\item{best_value}{Best known function value.}

\item{best_par}{Parameter settings that correspond to
\code{best_value}. If there are multiple global minima, this
should be a list with one entry for each minimum.}
}
\value{
A \code{soo_function} object.
}
\description{
Define a new \code{soo_function} object.
}
\examples{
## Given the following simple benchmark function:
f_my_sphere <- function(x)
  sum((x-1)*(x-1))

## we can define a corresponding 2d soo_function:
f <- soo_function("My Sphere", "my-sphere-2d", f_my_sphere, 2,
                  c(-10, -10), c(10, 10),
                  0, c(1, 1))

## And then plot it:
plot(f)

}
