% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/butter_filter.R
\name{butter_filter}
\alias{butter_filter}
\title{Apply a butterworth filter to sound samples}
\usage{
butter_filter(sound_samples, low = NA, high = NA, fs, tx, order = 10)
}
\arguments{
\item{sound_samples}{Numeric vector with the sound samples to filter}

\item{low}{Numeric. Minimum frequency in kHz for the butterworth filter}

\item{high}{Numeric. Maximum frequency in kHz for the butterworth filter}

\item{fs}{Integer with the sampling frequency of the recording}

\item{tx}{Integer indicating the expanded time factor of the recording}

\item{order}{Integer indicating the filter order to apply to the recording}
}
\value{
A vector with the filtered sound samples
}
\description{
Apply a butterworth filter, high pass or/and low pass,
to sound samples. Based on the function \link[signal]{butter}
}
\details{
Butterworth filter
}
\author{
Bruno Silva
}
\keyword{internal}
