% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soundcorrs.R
\name{vec2df.id}
\alias{vec2df.id}
\title{A vector to data frame converter for \code{\link{fitTable}}. This one only does the necessary minimum.}
\usage{
vec2df.id(data)
}
\arguments{
\item{data}{[numeric vector] The data to be converted.}
}
\value{
[data.frame] Converted \code{data}.
}
\description{
A vector to data frame converter for \code{\link{fitTable}}. This one only does the necessary minimum.
}
\examples{
dataset <- summary (sampleSoundCorrsData.abc)
models <- list (
	"model A" = list (
		formula = "Y ~ a/X",
		start = list (list(a=1))),
	"model B" = list (
		formula = "Y ~ a/(1+exp(1)^X)",
		start = list (list(a=1)))
)
fitTable (models, dataset, 1, vec2df.id)
}
