% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soundcorrs.R
\name{read.soundcorrs}
\alias{read.soundcorrs}
\title{Read data for a single language from a tsv file.}
\usage{
read.soundcorrs(file, name, col.aligned, transcription, separator = "\\\\|")
}
\arguments{
\item{file}{[character] Path to the data file in the wide format.}

\item{name}{[character] Name of the language.}

\item{col.aligned}{[character] Name of the column with the aligned words.}

\item{transcription}{[character] Path to the file with the transcription.}

\item{separator}{[character] String used to separate segments in \code{col.aligned}. Defaults to \code{"\\|"}.}
}
\value{
[scOne] An object containing the data and metadata for one language.
}
\description{
Read the data for one language, from a file in the wide format, and combine it with metadata into a \code{\link{soundcorrs}} object. To obtain a \code{soundcorrs} object containing data for multiple languages, see \code{\link{merge.soundcorrs}}.
}
\examples{
# path to sample data in the "wide format"
fNameData <- system.file ("extdata", "data-capitals.tsv", package="soundcorrs")
# path to a sample transcription
fNameTrans <- system.file ("extdata", "trans-common.tsv", package="soundcorrs")
ger <- read.soundcorrs (fNameData, "German", "ALIGNED.German", fNameTrans)
}
