% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothContours.R
\name{drawContour}
\alias{drawContour}
\title{Draw contour}
\usage{
drawContour(
  len,
  anchors,
  interpol,
  valueFloor,
  valueCeiling,
  duration_ms = 500,
  loessSpan = NULL
)
}
\arguments{
\item{len}{the required length of the output contour. If NULL, it will be
calculated based on the maximum time value (in ms) and \code{samplingRate}}

\item{anchors}{a numeric vector of values or a list/dataframe with one column
(value) or two columns (time and value). \code{achors$time} can be in ms
(with len=NULL) or in arbitrary units, eg 0 to 1 (with duration determined
by len, which must then be provided in ms). So anchors$time is assumed to
be in ms if len=NULL and relative if len is specified. \code{anchors$value}
can be on any scale.}

\item{interpol}{deprecated}

\item{valueFloor}{lowser/upper bounds for the contour}

\item{valueCeiling}{lowser/upper bounds for the contour}

\item{duration_ms}{contour duration, ms}

\item{loessSpan}{parameter that controlled the amount of smoothing when
interpolating pitch etc between anchors; passed on to
\code{\link[stats]{loess}}, so only has an effect if interpol = 'loess'}
}
\description{
Internal soundgen function
}
\details{
The core part of getSmoothContour() that actually performs the interpolation
between anchors.
}
\keyword{internal}
