% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matchPars.R
\name{matchPars}
\alias{matchPars}
\title{Match soundgen pars (experimental)}
\usage{
matchPars(
  target,
  samplingRate = NULL,
  pars = NULL,
  init = NULL,
  probMutation = 0.25,
  stepVariance = 0.1,
  maxIter = 50,
  minExpectedDelta = 0.001,
  compareSoundsPars = list(),
  verbose = TRUE
)
}
\arguments{
\item{target}{the sound we want to reproduce using soundgen: path to a .wav
file or numeric vector}

\item{samplingRate}{sampling rate of \code{target} (only needed if target is
a numeric vector, rather than a .wav file)}

\item{pars}{arguments to \code{\link{soundgen}} that we are attempting to
optimize}

\item{init}{a list of initial values for the optimized parameters \code{pars}
and the values of other arguments to soundgen that are fixed at non-default
values (if any)}

\item{probMutation}{the probability of a parameter mutating per iteration}

\item{stepVariance}{scale factor for calculating the size of mutations}

\item{maxIter}{maximum number of mutated sounds produced without improving
the fit to target}

\item{minExpectedDelta}{minimum improvement in fit to target required to
accept the new sound candidate}

\item{compareSoundsPars}{a list of control parameters passed to
\code{\link{compareSounds}}}

\item{verbose}{if TRUE, plays back the accepted candidate at each iteration
and reports the outcome}
}
\value{
Returns a list of length 2: \code{$history} contains the tried
  parameter values together with their fit to target (\code{$history$sim}),
  and \code{$pars} contains a list of the final - hopefully the best -
  parameter settings.
}
\description{
Attempts to find settings for \code{\link{soundgen}} that will reproduce an
existing sound. The principle is to mutate control parameters, trying to
improve fit to target. The currently implemented optimization algorithm is
simple hill climbing. Disclaimer: this function is experimental and may or
may not work for particular tasks. It is intended as a supplement to - not
replacement of - manual optimization. See vignette('sound_generation',
package = 'soundgen') for more information.
}
\examples{
\dontrun{
target = soundgen(sylLen = 600, pitch = c(300, 200),
                  rolloff = -15, play = TRUE, plot = TRUE)
# we hope to reproduce this sound

# Match pars based on acoustic analysis alone, without any optimization.
# This *MAY* match temporal structure, pitch, and stationary formants
m1 = matchPars(target = target,
               samplingRate = 16000,
               maxIter = 0,  # no optimization, only acoustic analysis
               verbose = TRUE)
cand1 = do.call(soundgen, c(m1$pars, list(
  temperature = 0.001, play = TRUE, plot = TRUE)))

# Try to improve the match by optimizing rolloff
# (this may take a few minutes to run, and the results may vary)
m2 = matchPars(target = target,
               samplingRate = 16000,
               pars = 'rolloff',
               maxIter = 100,
               verbose = TRUE)
# rolloff should be moving from default (-9) to target (-15):
sapply(m2$history, function(x) x$pars$rolloff)
cand2 = do.call(soundgen, c(m2$pars, list(play = TRUE, plot = TRUE)))
}
}
