% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sourcoise_clear.R
\name{sourcoise_clear}
\alias{sourcoise_clear}
\title{Cleans sourcoise cache}
\usage{
sourcoise_clear(
  what = sourcoise_status(root = root, prune = FALSE),
  root = NULL
)
}
\arguments{
\item{what}{(--) a tibble such as the one obtained by \code{sourcoise_status()}, possibly filtered}

\item{root}{to force root, not recommended (expert use)}
}
\value{
list of cleared files, plus a side-effect as specified cache files are deleted (no undo possible)
}
\description{
removes every json and qs2 files found by \code{sourcoise_status()} unless a specific tibble (filtered from \code{sourcoise_status()}) is passed as an argument.
}
\examples{
\dontshow{if (rlang::is_installed("insee")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
dir <- tempdir()
set_sourcoise_root(dir)
fs::file_copy(
    fs::path_package("sourcoise", "some_data.R"),
    dir,
    overwrite = TRUE)
# Force execution
data <- sourcoise("some_data.R", force_exec = TRUE)
# we then clear all caches
sourcoise_clear()
sourcoise_status()
\dontshow{\}) # examplesIf}
}
\seealso{
Other sourcoise: 
\code{\link{sourcoise}()},
\code{\link{sourcoise_refresh}()},
\code{\link{sourcoise_reset}()},
\code{\link{sourcoise_status}()}
}
\concept{sourcoise}
