% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/world.R
\docType{data}
\name{world}
\alias{world}
\alias{wrld}
\title{World country polygons}
\format{
Formal class 'sf' [package "sf"]; the data contains a data.frame with 177 obs. of 11 variables:
\itemize{
    \item{iso_a2} {character vector of ISO 2 character country codes}
    \item{name_long} {character vector of country names}
    \item{continent} {character vector of continent names}
    \item{region_un} {character vector of region names}
    \item{subregion} {character vector of subregion names}
    \item{type} {character vector of type names}
    \item{area_km2} {integer vector of area values}
    \item{pop} {integer vector of population in 2014}
    \item{lifeExp} {integer vector of life expectancy at birth in 2014}
    \item{gdpPercap} {integer vector of per-capita GDP in 2014}
    \item{geom} {sfc_MULTIPOLYGON}
}
The object is in geographical coordinates using the WGS84 datum.
}
\source{
\url{https://www.naturalearthdata.com/}

\url{https://data.worldbank.org/}
}
\usage{
world
}
\description{
The object loaded is a \code{sf} object containing a world map data from Natural Earth with a few variables from World Bank
}
\examples{
if (requireNamespace("sf", quietly = TRUE)) {
  library(sf)
  data(world)
  # or
  world <- st_read(system.file("shapes/world.gpkg", package="spData"))

  plot(world)
}
}
\seealso{
See the rnaturalearth package: https://cran.r-project.org/package=rnaturalearth
}
\keyword{datasets}
\keyword{sf}
