% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gcmc.R
\name{gcmc}
\alias{gcmc}
\alias{gcmc,sf-method}
\alias{gcmc,SpatRaster-method}
\title{geographical cross mapping cardinality}
\usage{
\S4method{gcmc}{sf}(
  data,
  cause,
  effect,
  libsizes = NULL,
  E = 3,
  k = pmin(E^2),
  tau = 1,
  style = 1,
  lib = NULL,
  pred = NULL,
  dist.metric = "L2",
  threads = detectThreads(),
  detrend = FALSE,
  parallel.level = "low",
  bidirectional = TRUE,
  progressbar = TRUE,
  nb = NULL
)

\S4method{gcmc}{SpatRaster}(
  data,
  cause,
  effect,
  libsizes = NULL,
  E = 3,
  k = pmin(E^2),
  tau = 1,
  style = 1,
  lib = NULL,
  pred = NULL,
  dist.metric = "L2",
  threads = detectThreads(),
  detrend = FALSE,
  parallel.level = "low",
  bidirectional = TRUE,
  progressbar = TRUE,
  grid.coord = TRUE
)
}
\arguments{
\item{data}{observation data.}

\item{cause}{name of causal variable.}

\item{effect}{name of effect variable.}

\item{libsizes}{(optional) number of spatial units used (input needed: \code{vector} - spatial vector, \code{matrix} - spatial raster).}

\item{E}{(optional) embedding dimensions.}

\item{k}{(optional) number of nearest neighbors.}

\item{tau}{(optional) step of spatial lags.}

\item{style}{(optional) embedding style (\code{0} includes current state, \code{1} excludes it).}

\item{lib}{(optional) libraries indices (input requirement same as \code{libsizes}).}

\item{pred}{(optional) predictions indices (input requirement same as \code{libsizes}).}

\item{dist.metric}{(optional) distance metric (\code{L1}: Manhattan, \code{L2}: Euclidean).}

\item{threads}{(optional) number of threads to use.}

\item{detrend}{(optional) whether to remove the linear trend.}

\item{parallel.level}{(optional) level of parallelism, \code{low} or \code{high}.}

\item{bidirectional}{(optional) whether to examine bidirectional causality.}

\item{progressbar}{(optional) whether to show the progress bar.}

\item{nb}{(optional) neighbours list.}

\item{grid.coord}{(optional) whether to detrend using cell center coordinates (\code{TRUE}) or row/column numbers (\code{FALSE}).}
}
\value{
A list
\describe{
\item{\code{xmap}}{cross mapping results}
\item{\code{cs}}{causal strength}
\item{\code{varname}}{names of causal and effect variables}
\item{\code{bidirectional}}{whether to examine bidirectional causality}
}
}
\description{
geographical cross mapping cardinality
}
\examples{
columbus = sf::read_sf(system.file("case/columbus.gpkg",package="spEDM"))
\donttest{
g = gcmc(columbus,"hoval","crime",E = 7,k = 18)
g
}
}
