# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title c++ quartic kernel
#' @name quartic_kernel_cpp
#' @param d a vector of distances for which the density must be calculated
#' @param bw a double representing the size of the kernel bandwidth
#' @keywords internal
quartic_kernel_cpp <- function(d, bw) {
    .Call('_spNetwork_quartic_kernel_cpp', PACKAGE = 'spNetwork', d, bw)
}

#' @title c++ quartic kernel for one distance
#' @name quartic_kernelos
#' @param d a double, the distances for which the density must be calculated
#' @param bw a double representing the size of the kernel bandwidth
#' @keywords internal
quartic_kernelos <- function(d, bw) {
    .Call('_spNetwork_quartic_kernelos', PACKAGE = 'spNetwork', d, bw)
}

#' @title c++ triangle kernel
#' @name triangle_kernel_cpp
#' @param d a vector of distances for which the density must be calculated
#' @param bw a double representing the size of the kernel bandwidth
#' @keywords internal
triangle_kernel_cpp <- function(d, bw) {
    .Call('_spNetwork_triangle_kernel_cpp', PACKAGE = 'spNetwork', d, bw)
}

#' @title c++ triangle kernel for one distance
#' @name triangle_kernelos
#' @param d a double, the distances for which the density must be calculated
#' @param bw a double representing the size of the kernel bandwidth
#' @keywords internal
triangle_kernelos <- function(d, bw) {
    .Call('_spNetwork_triangle_kernelos', PACKAGE = 'spNetwork', d, bw)
}

#' @title c++ uniform kernel
#' @name uniform_kernel_cpp
#' @param d a vector of distances for which the density must be calculated
#' @param bw a double representing the size of the kernel bandwidth
#' @keywords internal
uniform_kernel_cpp <- function(d, bw) {
    .Call('_spNetwork_uniform_kernel_cpp', PACKAGE = 'spNetwork', d, bw)
}

#' @title c++ uniform kernel for one distance
#' @name uniform_kernelos
#' @param d a double, the distances for which the density must be calculated
#' @param bw a double representing the size of the kernel bandwidth
#' @keywords internal
uniform_kernelos <- function(d, bw) {
    .Call('_spNetwork_uniform_kernelos', PACKAGE = 'spNetwork', d, bw)
}

#' @title c++ epanechnikov kernel
#' @name epanechnikov_kernel_cpp
#' @param d a vector of distances for which the density must be calculated
#' @param bw a double representing the size of the kernel bandwidth
#' @keywords internal
epanechnikov_kernel_cpp <- function(d, bw) {
    .Call('_spNetwork_epanechnikov_kernel_cpp', PACKAGE = 'spNetwork', d, bw)
}

#' @title c++ epanechnikov kernel for one distance
#' @name epanechnikov_kernelos
#' @param d a double, the distances for which the density must be calculated
#' @param bw a double representing the size of the kernel bandwidth
#' @keywords internal
epanechnikov_kernelos <- function(d, bw) {
    .Call('_spNetwork_epanechnikov_kernelos', PACKAGE = 'spNetwork', d, bw)
}

#' @title c++ triweight kernel
#' @name triweight_kernel_cpp
#' @param d a vector of distances for which the density must be calculated
#' @param bw a double representing the size of the kernel bandwidth
#' @keywords internal
triweight_kernel_cpp <- function(d, bw) {
    .Call('_spNetwork_triweight_kernel_cpp', PACKAGE = 'spNetwork', d, bw)
}

#' @title c++ triweight kernel for one distance
#' @name triweight_kernelos
#' @param d a double, the distances for which the density must be calculated
#' @param bw a double representing the size of the kernel bandwidth
#' @keywords internal
triweight_kernelos <- function(d, bw) {
    .Call('_spNetwork_triweight_kernelos', PACKAGE = 'spNetwork', d, bw)
}

#' @title c++ tricube kernel
#' @name tricube_kernel_cpp
#' @param d a vector of distances for which the density must be calculated
#' @param bw a double representing the size of the kernel bandwidth
#' @keywords internal
tricube_kernel_cpp <- function(d, bw) {
    .Call('_spNetwork_tricube_kernel_cpp', PACKAGE = 'spNetwork', d, bw)
}

#' @title c++ tricube kernel for one distance
#' @name tricube_kernelos
#' @param d a double, the distances for which the density must be calculated
#' @param bw a double representing the size of the kernel bandwidth
#' @keywords internal
tricube_kernelos <- function(d, bw) {
    .Call('_spNetwork_tricube_kernelos', PACKAGE = 'spNetwork', d, bw)
}

#' @title c++ cosine kernel
#' @name cosine_kernel_cpp
#' @param d a vector of distances for which the density must be calculated
#' @param bw a double representing the size of the kernel bandwidth
#' @keywords internal
cosine_kernel_cpp <- function(d, bw) {
    .Call('_spNetwork_cosine_kernel_cpp', PACKAGE = 'spNetwork', d, bw)
}

#' @title c++ cosine kernel for one distance
#' @name cosine_kernelos
#' @param d a double, the distances for which the density must be calculated
#' @param bw a double representing the size of the kernel bandwidth
#' @keywords internal
cosine_kernelos <- function(d, bw) {
    .Call('_spNetwork_cosine_kernelos', PACKAGE = 'spNetwork', d, bw)
}

#' @title c++ gaussian kernel
#' @name gaussian_kernel_cpp
#' @param d a vector of distances for which the density must be calculated
#' @param bw a double representing the size of the kernel bandwidth
#' @keywords internal
gaussian_kernel_cpp <- function(d, bw) {
    .Call('_spNetwork_gaussian_kernel_cpp', PACKAGE = 'spNetwork', d, bw)
}

#' @title c++ gaussian kernel for one distance
#' @name gaussian_kernelos
#' @param d a double, the distances for which the density must be calculated
#' @param bw a double representing the size of the kernel bandwidth
#' @keywords internal
gaussian_kernelos <- function(d, bw) {
    .Call('_spNetwork_gaussian_kernelos', PACKAGE = 'spNetwork', d, bw)
}

#' @title c++ scale gaussian kernel
#' @name gaussian_kernel_scaled_cpp
#' @param d a vector of distances for which the density must be calculated
#' @param bw a double representing the size of the kernel bandwidth
#' @keywords internal
gaussian_kernel_scaled_cpp <- function(d, bw) {
    .Call('_spNetwork_gaussian_kernel_scaled_cpp', PACKAGE = 'spNetwork', d, bw)
}

#' @title c++ scaled gaussian kernel for one distance
#' @name gaussian_kernel_scaledos
#' @param d a double, the distances for which the density must be calculated
#' @param bw a double representing the size of the kernel bandwidth
#' @keywords internal
gaussian_kernel_scaledos <- function(d, bw) {
    .Call('_spNetwork_gaussian_kernel_scaledos', PACKAGE = 'spNetwork', d, bw)
}

#' @title A function to calculate the necessary information to apply the
#' Diggle correction factor with a discontinuous method (sparse)
#' @name corrfactor_discontinuous_sparse
#' @param neighbour_list a list of the neighbours of each node
#' @param events a numeric vector of the node id of each event
#' @param line_list a DataFrame representing the lines of the graph
#' @param bws the kernel bandwidth for each event
#' @param max_depth the maximum recursion depth (after which recursion is stopped)
#' @return a list of dataframes, used to calculate the Diggel correction factor
#' @export
#' @keywords internal
corrfactor_discontinuous_sparse <- function(neighbour_list, events, line_list, bws, max_depth) {
    .Call('_spNetwork_corrfactor_discontinuous_sparse', PACKAGE = 'spNetwork', neighbour_list, events, line_list, bws, max_depth)
}

#' @title A function to calculate the necessary informations to apply the
#' Diggle correction factor with a discontinuous method
#' @name corrfactor_discontinuous
#' @param neighbour_list a list of the neighbours of each node
#' @param events a numeric vector of the node id of each event
#' @param line_list a DataFrame representing the lines of the graph
#' @param bws the kernel bandwidth for each event
#' @param max_depth the maximum recursion depth (after which recursion is stopped)
#' @return a list of dataframes, used to calculate the Diggel correction factor
#' @export
#' @keywords internal
corrfactor_discontinuous <- function(neighbour_list, events, line_list, bws, max_depth) {
    .Call('_spNetwork_corrfactor_discontinuous', PACKAGE = 'spNetwork', neighbour_list, events, line_list, bws, max_depth)
}

#' @title A function to calculate the necessary information to apply the
#' Diggle correction factor with a continuous method (sparse)
#' @name corrfactor_continuous_sparse
#' @param neighbour_list a list of the neighbours of each node
#' @param events a numeric vector of the node id of each event
#' @param line_list a DataFrame representing the lines of the graph
#' @param bws the kernel bandwidth for each event
#' @param max_depth the maximum recursion depth (after which recursion is stopped)
#' @return a list of dataframes, used to calculate the Diggel correction factor
#' @export
#' @keywords internal
corrfactor_continuous_sparse <- function(neighbour_list, events, line_list, bws, max_depth) {
    .Call('_spNetwork_corrfactor_continuous_sparse', PACKAGE = 'spNetwork', neighbour_list, events, line_list, bws, max_depth)
}

#' @title A function to calculate the necessary information to apply the
#' Diggle correction factor with a continuous method
#' @name corrfactor_continuous
#' @param neighbour_list a list of the neighbours of each node
#' @param events a numeric vector of the node id of each event
#' @param line_list a DataFrame representing the lines of the graph
#' @param bws the kernel bandwidth for each event
#' @param max_depth the maximum recursion depth (after which recursion is stopped)
#' @return a list of dataframes, used to calculate the Diggel correction factor
#' @export
#' @keywords internal
corrfactor_continuous <- function(neighbour_list, events, line_list, bws, max_depth) {
    .Call('_spNetwork_corrfactor_continuous', PACKAGE = 'spNetwork', neighbour_list, events, line_list, bws, max_depth)
}

#' @title The recursive function to calculate continuous NKDE likelihood cv
#' @name esc_kernel_loo
#' @param kernel_func a cpp pointer function (selected with the kernel name)
#' @param samples_k a numeric vector of the actual kernel values, updated at
#' each recursion
#' @param neighbour_list a List, giving for each node an IntegerVector with
#' its neighbours
#' @param edge_mat matrix, to find the id of each edge given two neighbours.
#' @param v the actual node to consider for the recursion (int)
#' @param v1 the connected node to consider for the recursion (int)
#' @param l1 the edge connecting v and v1 (int)
#' @param d the actual distance traveled before the recursion
#' @param alpha the actual alpha value before the recursion
#' @param bw the kernel bandwidth
#' @param line_weights a vector with the length of the edges
#' @param depth the actual recursion depth
#' @param max_depth the maximum recursion depth
#' @return a vector with the kernel values calculated for each samples from
#' the first node given
#' @keywords internal
NULL

#' @title The function to calculate discontinuous NKDE likelihood cv
#' @name esd_kernel_loo
#' @param kernel_func a cpp pointer function (selected with the kernel name)
#' @param samples_k a numeric vector of the actual kernel values, updated at
#' each recursion
#' @param neighbour_list a List, giving for each node an IntegerVector with
#' its neighbours
#' @param edge_mat matrix, to find the id of each edge given two neighbours.
#' @param v the actual node to consider for the recursion (int)
#' @param bw the kernel bandwidth
#' @param line_weights a vector with the length of the edges
#' @param depth the actual recursion depth
#' @param max_depth the maximum recursion depth
#' @return a vector with the kernel values calculated for each samples from
#' the first node given
#' @keywords internal
NULL

#' @title The function to calculate simple NKDE likelihood cv
#' @name esd_kernel_loo
#' @param kernel_func a cpp pointer function (selected with the kernel name)
#' @param samples_k a numeric vector of the actual kernel values, updated at
#' each recursion
#' @param neighbour_list a List, giving for each node an IntegerVector with
#' its neighbours
#' @param edge_mat matrix, to find the id of each edge given two neighbours.
#' @param v the actual node to consider for the recursion (int)
#' @param bw the kernel bandwidth
#' @param line_weights a vector with the length of the edges
#' @param depth the actual recursion depth
#' @param max_depth the maximum recursion depth
#' @return a vector with the kernel values calculated for each samples from
#' the first node given
#' @keywords internal
NULL

#' @title The exported function to calculate continuous NKDE likelihood cv
#' @name get_loo_values_continuous
#' @param neighbour_list a List, giving for each node an IntegerVector with
#' its neighbours
#' @param samples a vector with the node index of the samples
#' @param sweights a vector with the weight of each sample
#' @param events a vector with the node index of the events
#' @param weights a vector with the weights of the events
#' @param bws a vector with the bandwidths
#' @param kernel_name the name of the kernel function to use
#' @param line_list a dataframe representing the edges of the network
#' @param max_depth the maximum recursion depth
#' @return a vector with the kernel values calculated for each event
#' @export
#' @keywords internal
get_loo_values_continuous <- function(neighbour_list, samples, sweights, events, weights, bws, kernel_name, line_list, max_depth) {
    .Call('_spNetwork_get_loo_values_continuous', PACKAGE = 'spNetwork', neighbour_list, samples, sweights, events, weights, bws, kernel_name, line_list, max_depth)
}

#' @title The exported function to calculate discontinuous NKDE likelihood cv
#' @name get_loo_values_discontinuous
#' @param neighbour_list a List, giving for each node an IntegerVector with
#' its neighbours
#' @param samples a vector with the node index of the samples
#' @param sweights a vector with the weight of each sample
#' @param events a vector with the node index of the events
#' @param weights a vector with the weights of the events
#' @param bws a vector with the bandwidths
#' @param kernel_name the name of the kernel function to use
#' @param line_list a dataframe representing the edges of the network
#' @param max_depth the maximum recursion depth
#' @return a vector with the kernel values calculated for each event
#' @export
#' @keywords internal
get_loo_values_discontinuous <- function(neighbour_list, samples, sweights, events, weights, bws, kernel_name, line_list, max_depth) {
    .Call('_spNetwork_get_loo_values_discontinuous', PACKAGE = 'spNetwork', neighbour_list, samples, sweights, events, weights, bws, kernel_name, line_list, max_depth)
}

#' @title The exported function to calculate simple NKDE likelihood cv
#' @name get_loo_values_simple
#' @param neighbour_list a List, giving for each node an IntegerVector with
#' its neighbours
#' @param samples a vector with the node index of the samples
#' @param sweights a vector with the weight of each sample
#' @param events a vector with the node index of the events
#' @param weights a vector with the weights of the events
#' @param bws a vector with the bandwidths
#' @param kernel_name the name of the kernel function to use
#' @param line_list a dataframe representing the edges of the network
#' @param max_depth the maximum recursion depth
#' @return a vector with the kernel values calculated for each event
#' @export
#' @keywords internal
get_loo_values_simple <- function(neighbour_list, samples, sweights, events, weights, bws, kernel_name, line_list, max_depth) {
    .Call('_spNetwork_get_loo_values_simple', PACKAGE = 'spNetwork', neighbour_list, samples, sweights, events, weights, bws, kernel_name, line_list, max_depth)
}

find_nearest_object_in_line_rtree <- function(pts, lines, min_dist, max_iter) {
    .Call('_spNetwork_find_nearest_object_in_line_rtree', PACKAGE = 'spNetwork', pts, lines, min_dist, max_iter)
}

cut_lines_at_distances_cpp <- function(lines, dists) {
    .Call('_spNetwork_cut_lines_at_distances_cpp', PACKAGE = 'spNetwork', lines, dists)
}

add_vertices_lines_cpp <- function(points, lines, nearest_lines_idx, mindist) {
    .Call('_spNetwork_add_vertices_lines_cpp', PACKAGE = 'spNetwork', points, lines, nearest_lines_idx, mindist)
}

add_center_lines_cpp <- function(lines) {
    .Call('_spNetwork_add_center_lines_cpp', PACKAGE = 'spNetwork', lines)
}

split_lines_at_points_cpp <- function(Xmat, lines, nearest_lines_idx, mindist) {
    .Call('_spNetwork_split_lines_at_points_cpp', PACKAGE = 'spNetwork', Xmat, lines, nearest_lines_idx, mindist)
}

lixelize_lines_cpp <- function(lines, lx_length, mindist) {
    .Call('_spNetwork_lixelize_lines_cpp', PACKAGE = 'spNetwork', lines, lx_length, mindist)
}

#' @title The worker function to calculate continuous NKDE (with ARMADILLO and sparse matrix)
#' @name continuousWorker_sparse
#' @param kernel_func a cpp pointer function (selected with the kernel name)
#' @param samples_k a numeric vector of the actual kernel values, updates at
#' each recursion
#' @param neighbour_list a List, giving for each node an IntegerVector with
#' its neighbours
#' @param edge_mat matrix, to find the id of each edge given two neighbours.
#' @param v the actual node to consider for the recursion (int)
#' @param bw the kernel bandwidth
#' @param line_weights a vector with the length of the edges
#' @param samples_edgeid a vector associating each sample to an edge
#' @param samples_x a vector with x coordinates of each sample
#' @param samples_y a vector with y coordinates of each sample
#' @param nodes_x a vector with x coordinates of each node
#' @param nodes_y a vector with y coordinates of each node
#' @param depth the actual recursion depth
#' @param max_depth the maximum recursion depth
#' @return a vector with the kernel values calculated for each samples from
#' the first node given
#' @keywords internal
NULL

#' @title The worker function to calculate continuous NKDE (with ARMADILLO and integer matrix)
#' @name continuousWorker
#' @param kernel_func a cpp pointer function (selected with the kernel name)
#' @param samples_k a numeric vector of the actual kernel values, updates at
#' each recursion
#' @param neighbour_list a List, giving for each node an IntegerVector with
#' its neighbours
#' @param edge_mat matrix, to find the id of each edge given two neighbours.
#' @param v the actual node to consider for the recursion (int)
#' @param bw the kernel bandwidth
#' @param line_weights a vector with the length of the edges
#' @param samples_edgeid a vector associating each sample to an edge
#' @param samples_x a vector with x coordinates of each sample
#' @param samples_y a vector with y coordinates of each sample
#' @param nodes_x a vector with x coordinates of each node
#' @param nodes_y a vector with y coordinates of each node
#' @param depth the actual recursion depth
#' @param max_depth the maximum recursion depth
#' @return a vector with the kernel values calculated for each samples from
#' the first node given
#' @keywords internal
NULL

#' @title The main function to calculate continuous NKDE (with ARMADILO and sparse matrix)
#' @name continuousfunction
#' @param neighbour_list a list of the neighbours of each node
#' @param events a numeric vector of the node id of each event
#' @param weights a numeric vector of the weight of each event
#' @param samples a DataFrame of the samples (with spatial coordinates and belonging edge)
#' @param bws the kernel bandwidths for each event
#' @param kernel_name the name of the kernel to use
#' @param nodes a DataFrame representing the nodes of the graph (with spatial coordinates)
#' @param line_list a DataFrame representing the lines of the graph
#' @param max_depth the maximum recursion depth (after which recursion is stopped)
#' @param verbose a boolean indicating if the function must print its progress
#' @return a DataFrame with two columns : the kernel values (sum_k) and the number of events for each sample (n)
#' @export
#' @keywords internal
#'
continuous_nkde_cpp_arma_sparse <- function(neighbour_list, events, weights, samples, bws, kernel_name, nodes, line_list, max_depth, verbose) {
    .Call('_spNetwork_continuous_nkde_cpp_arma_sparse', PACKAGE = 'spNetwork', neighbour_list, events, weights, samples, bws, kernel_name, nodes, line_list, max_depth, verbose)
}

#' @title The main function to calculate continuous NKDE (with ARMADILO and integer matrix)
#' @name continuousfunction
#' @param neighbour_list a list of the neighbours of each node
#' @param events a numeric vector of the node id of each event
#' @param weights a numeric vector of the weight of each event
#' @param samples a DataFrame of the samples (with spatial coordinates and belonging edge)
#' @param bws the kernel bandwidths for each event
#' @param kernel_name the name of the kernel to use
#' @param nodes a DataFrame representing the nodes of the graph (with spatial coordinates)
#' @param line_list a DataFrame representing the lines of the graph
#' @param max_depth the maximum recursion depth (after which recursion is stopped)
#' @param verbose a boolean indicating if the function must print its progress
#' @return a DataFrame with two columns : the kernel values (sum_k) and the number of events for each sample (n)
#' @export
#' @keywords internal
#'
continuous_nkde_cpp_arma <- function(neighbour_list, events, weights, samples, bws, kernel_name, nodes, line_list, max_depth, verbose) {
    .Call('_spNetwork_continuous_nkde_cpp_arma', PACKAGE = 'spNetwork', neighbour_list, events, weights, samples, bws, kernel_name, nodes, line_list, max_depth, verbose)
}

#' @title The worker function to calculate discontinuous NKDE (with ARMADILLO and sparse matrix)
#' @name discontinuousWorker_sparse
#' @param kernel_func a cpp pointer function (selected with the kernel name)
#' @param edge_mat matrix, to find the id of each edge given two neighbours
#' @param neighbour_list a List, giving for each node an IntegerVector with
#' its neighbours
#' @param v the actual node to consider for the recursion (int)
#' @param bw the kernel bandiwdth
#' @param line_weights a vector with the length of the edges
#' @param samples_edgeid a vector associating each sample to an edge
#' @param samples_x a vector with x coordinates of each sample
#' @param samples_ya vector with y coordinates of each sample
#' @param nodes_x a vector with x coordinates of each node
#' @param nodes_y a vector with y coordinates of each node
#' @param depth the actual recursion depth
#' @param max_depth the maximum recursion depth
#' @return a vector with the kernel values calculated for each samples from
#' the first node given
#' @keywords internal
NULL

#' @title The worker function to calculate discontinuous NKDE (with ARMADILLO and Integer matrix)
#' @name discontinuousWorker_int
#' @param kernel_func a cpp pointer function (selected with the kernel name)
#' @param edge_mat matrix, to find the id of each edge given two neighbours
#' @param neighbour_list a List, giving for each node an IntegerVector with
#' its neighbours
#' @param v the actual node to consider for the recursion (int)
#' @param bw the kernel bandiwdth
#' @param line_weights a vector with the length of the edges
#' @param samples_edgeid a vector associating each sample to an edge
#' @param samples_x a vector with x coordinates of each sample
#' @param samples_ya vector with y coordinates of each sample
#' @param nodes_x a vector with x coordinates of each node
#' @param nodes_y a vector with y coordinates of each node
#' @param depth the actual recursion depth
#' @param max_depth the maximum recursion depth
#' @return a vector with the kernel values calculated for each samples from
#' the first node given
#' @keywords internal
NULL

#' @title The main function to calculate discontinuous NKDE (ARMA and sparse matrix)
#' @name discontinuousfunction
#' @param neighbour_list a list of the neighbours of each node
#' @param events a numeric vector of the node id of each event
#' @param weights a numeric vector of the weight of each event
#' @param samples a DataFrame of the samples (with spatial coordinates and belonging edge)
#' @param bws the kernel bandwidths for each event
#' @param kernel_name the name of the kernel function to use
#' @param nodes a DataFrame representing the nodes of the graph (with spatial coordinates)
#' @param line_list a DataFrame representing the lines of the graph
#' @param max_depth the maximum recursion depth (after which recursion is stopped)
#' @param verbose a boolean indicating if the function must print its progress
#' @return a DataFrame with two columns : the kernel values (sum_k) and the number of events for each sample (n)
#' @export
#' @keywords internal
discontinuous_nkde_cpp_arma_sparse <- function(neighbour_list, events, weights, samples, bws, kernel_name, nodes, line_list, max_depth, verbose) {
    .Call('_spNetwork_discontinuous_nkde_cpp_arma_sparse', PACKAGE = 'spNetwork', neighbour_list, events, weights, samples, bws, kernel_name, nodes, line_list, max_depth, verbose)
}

#' @title The main function to calculate discontinuous NKDE (ARMA and Integer matrix)
#' @name discontinuousfunction
#' @param neighbour_list a list of the neighbours of each node
#' @param events a numeric vector of the node id of each event
#' @param weights a numeric vector of the weight of each event
#' @param samples a DataFrame of the samples (with spatial coordinates and belonging edge)
#' @param bws the kernel bandwidth for each event
#' @param kernel_name the name of the kernel function to use
#' @param nodes a DataFrame representing the nodes of the graph (with spatial coordinates)
#' @param line_list a DataFrame representing the lines of the graph
#' @param max_depth the maximum recursion depth (after which recursion is stopped)
#' @param verbose a boolean indicating if the function must print its progress
#' @return a DataFrame with two columns : the kernel values (sum_k) and the number of events for each sample (n)
#' @export
#' @keywords internal
discontinuous_nkde_cpp_arma <- function(neighbour_list, events, weights, samples, bws, kernel_name, nodes, line_list, max_depth, verbose) {
    .Call('_spNetwork_discontinuous_nkde_cpp_arma', PACKAGE = 'spNetwork', neighbour_list, events, weights, samples, bws, kernel_name, nodes, line_list, max_depth, verbose)
}

