% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrs_data_display.R
\name{stackplot.mrs_data}
\alias{stackplot.mrs_data}
\title{Stackplot plotting method for objects of class mrs_data.}
\usage{
\method{stackplot}{mrs_data}(x, xlim = NULL, mode = "re",
  x_units = NULL, fd = TRUE, col = NULL, x_offset = 0,
  y_offset = 5, dim = "dyn", x_pos = NULL, y_pos = NULL,
  z_pos = NULL, dyn = 1, coil = 1, bty = NULL, labels = NULL,
  lab_cex = 1, right_marg = NULL, restore_def_par = TRUE, ...)
}
\arguments{
\item{x}{object of class mrs_data.}

\item{xlim}{the range of values to display on the x-axis, eg xlim = c(4,1).}

\item{mode}{representation of the complex numbers to be plotted, can be one
of: "re", "im", "mod" or "arg".}

\item{x_units}{the units to use for the x-axis, can be one of: "ppm", "hz",
"points" or "seconds".}

\item{fd}{display data in the frequency-domain (default), or time-domain
(logical).}

\item{col}{set the colour of the line, eg col = rgb(1,0,0,0.5).}

\item{x_offset}{separate plots in the x-axis direction by this value.
Default value is 0.}

\item{y_offset}{separate plots in the y-axis direction by this value.}

\item{dim}{the dimension to stack in the y-axis direction, can be one of:
"dyn", "x", "y", "z" or "coil".}

\item{x_pos}{the x index to plot.}

\item{y_pos}{the y index to plot.}

\item{z_pos}{the z index to plot.}

\item{dyn}{the dynamic index to plot.}

\item{coil}{the coil element number to plot.}

\item{bty}{option to draw a box around the plot. See ?par.}

\item{labels}{add labels to each data item.}

\item{lab_cex}{label size.}

\item{right_marg}{change the size of the right plot margin.}

\item{restore_def_par}{restore default plotting par values after the plot has
been made.}

\item{...}{other arguments to pass to the matplot method.}
}
\description{
Stackplot plotting method for objects of class mrs_data.
}
