% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_utils.R
\name{ml_prepare_dataframe}
\alias{ml_prepare_dataframe}
\title{Prepare a Spark DataFrame for Spark ML Routines}
\usage{
ml_prepare_dataframe(x, features, response = NULL, ...,
  ml.options = ml_options(), envir = new.env(parent = emptyenv()))
}
\arguments{
\item{x}{An object coercable to a Spark DataFrame (typically, a
\code{tbl_spark}).}

\item{features}{The name of features (terms) to use for the model fit.}

\item{response}{The name of the response vector (as a length-one character
vector), or a formula, giving a symbolic description of the model to be
fitted. When \code{response} is a formula, it is used in preference to other
parameters to set the \code{response}, \code{features}, and \code{intercept}
parameters (if available). Currently, only simple linear combinations of
existing parameters is supposed; e.g. \code{response ~ feature1 + feature2 + ...}.
The intercept term can be omitted by using \code{- 1} in the model fit.}

\item{...}{Optional arguments. The \code{data} argument can be used to
specify the data to be used when \code{x} is a formula; this allows calls
of the form \code{ml_linear_regression(y ~ x, data = tbl)}, and is
especially useful in conjunction with \code{\link{do}}.}

\item{ml.options}{Optional arguments, used to affect the model generated. See
\code{\link{ml_options}} for more details.}

\item{envir}{An \R environment -- when supplied, it will be filled
with metadata describing the transformations that have taken place.}
}
\description{
This routine prepares a Spark DataFrame for use by Spark ML routines.
}
\details{
Spark DataFrames are prepared through the following transformations:

\enumerate{
  \item All specified columns are transformed into a numeric data type
        (using a simple cast for integer / logical columns, and
        \code{\link{ft_string_indexer}} for strings),
  \item The \code{\link{ft_vector_assembler}} is used to combine the
        specified features into a single 'feature' vector, suitable
        for use with Spark ML routines.
}

After calling this function, the \code{envir} environment (when supplied)
will be populated with a set of variables:

\tabular{ll}{
\code{features}:\tab The name of the generated \code{features} vector.\cr
\code{response}:\tab The name of the generated \code{response} vector.\cr
\code{labels}:  \tab When the \code{response} column is a string vector,
                     the \code{\link{ft_string_indexer}} is used to transform
                     the vector into a [0:n) numeric vector. The ordered
                     labels are injected here to allow for easier mapping
                     from the [0:n) values back to the original label.
}
}
\examples{
\dontrun{
# example of how 'ml_prepare_dataframe' might be used to invoke
# Spark's LinearRegression routine from the 'ml' package
envir <- new.env(parent = emptyenv())
tdf <- ml_prepare_dataframe(df, features, response, envir = envir)

lr <- invoke_new(
  sc,
  "org.apache.spark.ml.regression.LinearRegression"
)

# use generated 'features', 'response' vector names in model fit
model <- lr \%>\%
  invoke("setFeaturesCol", envir$features) \%>\%
  invoke("setLabelCol", envir$response)
}
}

