% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_interface.R
\name{spark_read_csv}
\alias{spark_read_csv}
\title{Read a CSV file into a Spark DataFrame}
\usage{
spark_read_csv(
  sc,
  name = NULL,
  path = name,
  header = TRUE,
  columns = NULL,
  infer_schema = is.null(columns),
  delimiter = ",",
  quote = "\\"",
  escape = "\\\\",
  charset = "UTF-8",
  null_value = NULL,
  options = list(),
  repartition = 0,
  memory = TRUE,
  overwrite = TRUE,
  ...
)
}
\arguments{
\item{sc}{A \code{spark_connection}.}

\item{name}{The name to assign to the newly generated table.}

\item{path}{The path to the file. Needs to be accessible from the cluster.
Supports the \samp{"hdfs://"}, \samp{"s3a://"} and \samp{"file://"} protocols.}

\item{header}{Boolean; should the first row of data be used as a header?
Defaults to \code{TRUE}.}

\item{columns}{A vector of column names or a named vector of column types.
If specified, the elements can be \code{"binary"} for \code{BinaryType},
\code{"boolean"} for \code{BooleanType}, \code{"byte"} for \code{ByteType},
\code{"integer"} for \code{IntegerType}, \code{"integer64"} for \code{LongType},
\code{"double"} for \code{DoubleType}, \code{"character"} for \code{StringType},
\code{"timestamp"} for \code{TimestampType} and \code{"date"} for \code{DateType}.}

\item{infer_schema}{Boolean; should column types be automatically inferred?
Requires one extra pass over the data. Defaults to \code{is.null(columns)}.}

\item{delimiter}{The character used to delimit each column. Defaults to \samp{','}.}

\item{quote}{The character used as a quote. Defaults to \samp{'"'}.}

\item{escape}{The character used to escape other characters. Defaults to \samp{'\'}.}

\item{charset}{The character set. Defaults to \samp{"UTF-8"}.}

\item{null_value}{The character to use for null, or missing, values. Defaults to \code{NULL}.}

\item{options}{A list of strings with additional options.}

\item{repartition}{The number of partitions used to distribute the
generated table. Use 0 (the default) to avoid partitioning.}

\item{memory}{Boolean; should the data be loaded eagerly into memory? (That
is, should the table be cached?)}

\item{overwrite}{Boolean; overwrite the table with the given name if it
already exists?}

\item{...}{Optional arguments; currently unused.}
}
\description{
Read a tabular data file into a Spark DataFrame.
}
\details{
You can read data from HDFS (\code{hdfs://}), S3 (\code{s3a://}),
  as well as the local file system (\code{file://}).

If you are reading from a secure S3 bucket be sure to set the following in your spark-defaults.conf
\code{spark.hadoop.fs.s3a.access.key}, \code{spark.hadoop.fs.s3a.secret.key} or any of the methods outlined in the aws-sdk
documentation \href{http://docs.aws.amazon.com/sdk-for-java/v1/developer-guide/credentials.html}{Working with AWS credentials}
In order to work with the newer \code{s3a://} protocol also set the values for \code{spark.hadoop.fs.s3a.impl} and \code{spark.hadoop.fs.s3a.endpoint }.
In addition, to support v4 of the S3 api be sure to pass the \code{-Dcom.amazonaws.services.s3.enableV4} driver options
for the config key \code{spark.driver.extraJavaOptions }
For instructions on how to configure \code{s3n://} check the hadoop documentation:
\href{https://hadoop.apache.org/docs/stable/hadoop-aws/tools/hadoop-aws/index.html#Authentication_properties}{s3n authentication properties}

When \code{header} is \code{FALSE}, the column names are generated with a
\code{V} prefix; e.g. \code{V1, V2, ...}.
}
\seealso{
Other Spark serialization routines: 
\code{\link{spark_load_table}()},
\code{\link{spark_read_avro}()},
\code{\link{spark_read_delta}()},
\code{\link{spark_read_jdbc}()},
\code{\link{spark_read_json}()},
\code{\link{spark_read_libsvm}()},
\code{\link{spark_read_orc}()},
\code{\link{spark_read_parquet}()},
\code{\link{spark_read_source}()},
\code{\link{spark_read_table}()},
\code{\link{spark_read_text}()},
\code{\link{spark_read}()},
\code{\link{spark_save_table}()},
\code{\link{spark_write_avro}()},
\code{\link{spark_write_csv}()},
\code{\link{spark_write_delta}()},
\code{\link{spark_write_jdbc}()},
\code{\link{spark_write_json}()},
\code{\link{spark_write_orc}()},
\code{\link{spark_write_parquet}()},
\code{\link{spark_write_source}()},
\code{\link{spark_write_table}()},
\code{\link{spark_write_text}()}
}
\concept{Spark serialization routines}
