/*
 * Decompiled with CFR 0.152.
 */
package sparklyr;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.convert.Wrappers;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray;
import scala.math.BigDecimal$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import sparklyr.JVMObjectTracker;
import sparklyr.StructTypeAsJSON;

@ScalaSignature(bytes="\u0006\u0001\t\u0005g\u0001B\u001a5\u0001]B\u0001B\u0010\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\u0006\u0007\u0002!\t\u0001R\u0003\u0005\u000f\u0002\u0001\u0001*\u0002\u0003]\u0001\u0001i\u0006\"\u00033\u0001\u0001\u0004\u0005\r\u0011\"\u0001f\u0011%a\u0007\u00011AA\u0002\u0013\u0005Q\u000eC\u0005t\u0001\u0001\u0007\t\u0011)Q\u0005M\")A\u000f\u0001C\u0001k\")q\u000f\u0001C\u0001q\")1\u0010\u0001C\u0001y\")a\u0010\u0001C\u0001\u007f\"9\u0011q\u0001\u0001\u0005\u0002\u0005%\u0001bBA\u000e\u0001\u0011\u0005\u0011Q\u0004\u0005\b\u0003O\u0001A\u0011AA\u0015\u0011\u001d\t\u0019\u0004\u0001C\u0001\u0003kAq!a\u0015\u0001\t\u0003\t)\u0006C\u0004\u0002Z\u0001!\t!a\u0017\t\u000f\u0005}\u0003\u0001\"\u0001\u0002b!9\u0011\u0011\u000f\u0001\u0005\u0002\u0005M\u0004bBA?\u0001\u0011\u0005\u0011q\u0010\u0005\b\u0003\u000b\u0003A\u0011AAD\u0011\u001d\ti\t\u0001C\u0001\u0003\u001fCq!!&\u0001\t\u0003\t9\nC\u0004\u0002\u001e\u0002!\t!a(\t\u000f\u0005\u0015\u0006\u0001\"\u0001\u0002(\"9\u0011Q\u0019\u0001\u0005\u0002\u0005\u001d\u0007bBAk\u0001\u0011\u0005\u0011q\u001b\u0005\b\u0003;\u0004A\u0011AAp\u0011\u001d\t)\u000f\u0001C\u0001\u0003ODq!!>\u0001\t\u0003\t9\u0010C\u0004\u0002~\u0002!\t!a@\t\u000f\t]\u0001\u0001\"\u0001\u0003\u001a!9!1\u0005\u0001\u0005\n\t\u0015\u0002b\u0002B\u0019\u0001\u0011\u0005!1\u0007\u0005\b\u0005w\u0001A\u0011\u0001B\u001f\u0011\u001d\u0011)\u0005\u0001C\u0001\u0005\u000fBqA!\u0014\u0001\t\u0003\u0011y\u0005C\u0004\u0003V\u0001!\tAa\u0016\t\u000f\tu\u0003\u0001\"\u0001\u0003`!9!Q\f\u0001\u0005\u0002\t-\u0004b\u0002B9\u0001\u0011\u0005!1\u000f\u0005\b\u0005s\u0002A\u0011\u0001B>\u0011\u001d\u0011\t\t\u0001C\u0001\u0005\u0007CqA!#\u0001\t\u0003\u0011Y\tC\u0004\u0003\u0012\u0002!\tAa%\t\u000f\te\u0005\u0001\"\u0001\u0003\u001c\"9!\u0011\u0015\u0001\u0005\u0002\t\r\u0006b\u0002BU\u0001\u0011\u0005!1\u0016\u0005\b\u0005c\u0003A\u0011\u0001BZ\u0011\u001d\u0011I\f\u0001C\u0001\u0005w\u0013!bU3sS\u0006d\u0017N_3s\u0015\u0005)\u0014\u0001C:qCJ\\G.\u001f:\u0004\u0001M\u0011\u0001\u0001\u000f\t\u0003sqj\u0011A\u000f\u0006\u0002w\u0005)1oY1mC&\u0011QH\u000f\u0002\u0007\u0003:L(+\u001a4\u0002\u000fQ\u0014\u0018mY6feB\u0011\u0001)Q\u0007\u0002i%\u0011!\t\u000e\u0002\u0011\u0015ZkuJ\u00196fGR$&/Y2lKJ\fa\u0001P5oSRtDCA#G!\t\u0001\u0005\u0001C\u0003?\u0005\u0001\u0007qH\u0001\u0006SK\u0006$wJ\u00196fGR\u0004R!O%L'ZK!A\u0013\u001e\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004C\u0001'R\u001b\u0005i%B\u0001(P\u0003\tIwNC\u0001Q\u0003\u0011Q\u0017M^1\n\u0005Ik%a\u0004#bi\u0006Le\u000e];u'R\u0014X-Y7\u0011\u0005e\"\u0016BA+;\u0005\u0011\u0019\u0005.\u0019:\u0011\u0005]SV\"\u0001-\u000b\u0005e{\u0015\u0001\u00027b]\u001eL!a\u0017-\u0003\r=\u0013'.Z2u\u0005-9&/\u001b;f\u001f\nTWm\u0019;\u0011\u000beJeLV1\u0011\u00051{\u0016B\u00011N\u0005A!\u0015\r^1PkR\u0004X\u000f^*ue\u0016\fW\u000e\u0005\u0002:E&\u00111M\u000f\u0002\b\u0005>|G.Z1o\u0003!\u0019\u0018\u000f\\*fe\u0012+W#\u00014\u0011\te:\u0017n[\u0005\u0003Qj\u0012a\u0001V;qY\u0016\u0014\u0004C\u00016\u0004\u001b\u0005\u0001\u0001C\u00016\u0005\u00031\u0019\u0018\u000f\\*fe\u0012+w\fJ3r)\tq\u0017\u000f\u0005\u0002:_&\u0011\u0001O\u000f\u0002\u0005+:LG\u000fC\u0004s\r\u0005\u0005\t\u0019\u00014\u0002\u0007a$\u0013'A\u0005tc2\u001cVM\u001d#fA\u0005\u0001\"/Z4jgR,'oU9m'\u0016\u0014H)\u001a\u000b\u0003]ZDQ\u0001\u001a\u0005A\u0002\u0019\faB]3bI>\u0013'.Z2u)f\u0004X\r\u0006\u0002Ts\")!0\u0003a\u0001\u0017\u0006\u0019A-[:\u0002\u0015I,\u0017\rZ(cU\u0016\u001cG\u000f\u0006\u0002W{\")!P\u0003a\u0001\u0017\u0006y!/Z1e)f\u0004X\rZ(cU\u0016\u001cG\u000fF\u0003W\u0003\u0003\t\u0019\u0001C\u0003{\u0017\u0001\u00071\n\u0003\u0004\u0002\u0006-\u0001\raU\u0001\tI\u0006$\u0018\rV=qK\u0006I!/Z1e\u0005f$Xm\u001d\u000b\u0005\u0003\u0017\t9\u0002E\u0003:\u0003\u001b\t\t\"C\u0002\u0002\u0010i\u0012Q!\u0011:sCf\u00042!OA\n\u0013\r\t)B\u000f\u0002\u0005\u0005f$X\r\u0003\u0004\u0002\u001a1\u0001\raS\u0001\u0003S:\fqA]3bI&sG\u000f\u0006\u0003\u0002 \u0005\u0015\u0002cA\u001d\u0002\"%\u0019\u00111\u0005\u001e\u0003\u0007%sG\u000f\u0003\u0004\u0002\u001a5\u0001\raS\u0001\u000be\u0016\fG\rR8vE2,G\u0003BA\u0016\u0003c\u00012!OA\u0017\u0013\r\tyC\u000f\u0002\u0007\t>,(\r\\3\t\r\u0005ea\u00021\u0001L\u0003=\u0011X-\u00193TiJLgn\u001a\"zi\u0016\u001cHCBA\u001c\u0003\u001b\ny\u0005\u0005\u0003\u0002:\u0005\u001dc\u0002BA\u001e\u0003\u0007\u00022!!\u0010;\u001b\t\tyDC\u0002\u0002BY\na\u0001\u0010:p_Rt\u0014bAA#u\u00051\u0001K]3eK\u001aLA!!\u0013\u0002L\t11\u000b\u001e:j]\u001eT1!!\u0012;\u0011\u0019\tIb\u0004a\u0001\u0017\"9\u0011\u0011K\bA\u0002\u0005}\u0011a\u00017f]\u0006Q!/Z1e'R\u0014\u0018N\\4\u0015\t\u0005]\u0012q\u000b\u0005\u0007\u00033\u0001\u0002\u0019A&\u0002\u0017I,\u0017\r\u001a\"p_2,\u0017M\u001c\u000b\u0004C\u0006u\u0003BBA\r#\u0001\u00071*\u0001\u0005sK\u0006$G)\u0019;f)\u0011\t\u0019'a\u001c\u0011\t\u0005\u0015\u00141N\u0007\u0003\u0003OR1!!\u001bP\u0003\r\u0019\u0018\u000f\\\u0005\u0005\u0003[\n9G\u0001\u0003ECR,\u0007BBA\r%\u0001\u00071*\u0001\u0005sK\u0006$G+[7f)\u0011\t)(a\u001f\u0011\t\u0005\u0015\u0014qO\u0005\u0005\u0003s\n9GA\u0005US6,7\u000f^1na\"1\u0011\u0011D\nA\u0002-\u000bAB]3bI\nKH/Z:BeJ$B!!!\u0002\u0004B)\u0011(!\u0004\u0002\f!1\u0011\u0011\u0004\u000bA\u0002-\u000b!B]3bI&sG/\u0011:s)\u0011\tI)a#\u0011\u000be\ni!a\b\t\r\u0005eQ\u00031\u0001L\u00035\u0011X-\u00193E_V\u0014G.Z!seR!\u0011\u0011SAJ!\u0015I\u0014QBA\u0016\u0011\u0019\tIB\u0006a\u0001\u0017\u0006q!/Z1e\u0005>|G.Z1o\u0003J\u0014H\u0003BAM\u00037\u0003B!OA\u0007C\"1\u0011\u0011D\fA\u0002-\u000bQB]3bIN#(/\u001b8h\u0003J\u0014H\u0003BAQ\u0003G\u0003R!OA\u0007\u0003oAa!!\u0007\u0019\u0001\u0004Y\u0015\u0001\u0004:fC\u0012\f%O]1z\u0003J\u0014H\u0003BAU\u0003\u0007\u0004D!a+\u00022B)\u0011(!\u0004\u0002.B!\u0011qVAY\u0019\u0001!1\"a-\u001a\u0003\u0003\u0005\tQ!\u0001\u00026\n\u0019q\fJ\u0019\u0012\t\u0005]\u0016Q\u0018\t\u0004s\u0005e\u0016bAA^u\t9aj\u001c;iS:<\u0007cA\u001d\u0002@&\u0019\u0011\u0011\u0019\u001e\u0003\u0007\u0005s\u0017\u0010\u0003\u0004\u0002\u001ae\u0001\raS\u0001\fe\u0016\fG\rT5ti\u0006\u0013(\u000f\u0006\u0003\u0002J\u0006M\u0007\u0007BAf\u0003\u001f\u0004R!OA\u0007\u0003\u001b\u0004B!a,\u0002P\u0012Y\u0011\u0011\u001b\u000e\u0002\u0002\u0003\u0005)\u0011AA[\u0005\ryFE\r\u0005\u0007\u00033Q\u0002\u0019A&\u0002\u0017I,\u0017\r\u001a#bi\u0016\f%O\u001d\u000b\u0005\u00033\fY\u000eE\u0003:\u0003\u001b\t\u0019\u0007\u0003\u0004\u0002\u001am\u0001\raS\u0001\fe\u0016\fG\rV5nK\u0006\u0013(\u000f\u0006\u0003\u0002b\u0006\r\b#B\u001d\u0002\u000e\u0005U\u0004BBA\r9\u0001\u00071*A\u0005sK\u0006$\u0017I\u001d:bsR!\u0011\u0011^Aza\u0011\tY/a<\u0011\u000be\ni!!<\u0011\t\u0005=\u0016q\u001e\u0003\f\u0003cl\u0012\u0011!A\u0001\u0006\u0003\t)LA\u0002`IMBQA_\u000fA\u0002-\u000b\u0001B]3bI2K7\u000f\u001e\u000b\u0005\u0003s\fY\u0010\u0005\u0003:\u0003\u001b1\u0006\"\u0002>\u001f\u0001\u0004Y\u0015a\u0002:fC\u0012l\u0015\r\u001d\u000b\u0005\u0005\u0003\u0011)\u0002\r\u0004\u0003\u0004\t-!\u0011\u0003\t\t\u0003s\u0011)A!\u0003\u0003\u0010%!!qAA&\u0005\ri\u0015\r\u001d\t\u0005\u0003_\u0013Y\u0001B\u0006\u0003\u000e}\t\t\u0011!A\u0003\u0002\u0005U&aA0%iA!\u0011q\u0016B\t\t-\u0011\u0019bHA\u0001\u0002\u0003\u0015\t!!.\u0003\u0007}#S\u0007\u0003\u0004\u0002\u001a}\u0001\raS\u0001\noJLG/\u001a+za\u0016$RA\u001cB\u000e\u0005?AaA!\b!\u0001\u0004q\u0016a\u00013pg\"9!\u0011\u0005\u0011A\u0002\u0005]\u0012a\u0002;za\u0016\u001cFO]\u0001\u000eoJLG/Z&fsZ\u000bG.^3\u0015\u000f9\u00149C!\u000b\u0003.!1!QD\u0011A\u0002yCaAa\u000b\"\u0001\u00041\u0016aA6fs\"1!qF\u0011A\u0002Y\u000bQA^1mk\u0016\f1b\u001e:ji\u0016|%M[3diR)aN!\u000e\u00038!1!Q\u0004\u0012A\u0002yCaA!\u000f#\u0001\u00041\u0016aA8cU\u0006AqO]5uK&sG\u000fF\u0003o\u0005\u007f\u0011\u0019\u0005\u0003\u0004\u0003B\r\u0002\rAX\u0001\u0004_V$\bb\u0002B\u0018G\u0001\u0007\u0011qD\u0001\foJLG/\u001a#pk\ndW\rF\u0003o\u0005\u0013\u0012Y\u0005\u0003\u0004\u0003B\u0011\u0002\rA\u0018\u0005\b\u0005_!\u0003\u0019AA\u0016\u000319(/\u001b;f\u0005>|G.Z1o)\u0015q'\u0011\u000bB*\u0011\u0019\u0011\t%\na\u0001=\"1!qF\u0013A\u0002\u0005\f\u0011b\u001e:ji\u0016$\u0015\r^3\u0015\u000b9\u0014IFa\u0017\t\r\t\u0005c\u00051\u0001_\u0011\u001d\u0011yC\na\u0001\u0003G\n\u0011b\u001e:ji\u0016$\u0016.\\3\u0015\u000b9\u0014\tGa\u0019\t\r\t\u0005s\u00051\u0001_\u0011\u001d\u0011yc\na\u0001\u0005K\u0002B!!\u001a\u0003h%!!\u0011NA4\u0005\u0011!\u0016.\\3\u0015\u000b9\u0014iGa\u001c\t\r\t\u0005\u0003\u00061\u0001_\u0011\u001d\u0011y\u0003\u000ba\u0001\u0003k\n1b\u001e:ji\u0016\u001cFO]5oOR)aN!\u001e\u0003x!1!\u0011I\u0015A\u0002yCqAa\f*\u0001\u0004\t9$\u0001\u0006xe&$XMQ=uKN$RA\u001cB?\u0005\u007fBaA!\u0011+\u0001\u0004q\u0006b\u0002B\u0018U\u0001\u0007\u00111B\u0001\noJLG/\u001a&PE*$RA\u001cBC\u0005\u000fCaA!\u0011,\u0001\u0004q\u0006B\u0002B\u0018W\u0001\u0007a+A\u0006xe&$X-\u00138u\u0003J\u0014H#\u00028\u0003\u000e\n=\u0005B\u0002B!Y\u0001\u0007a\fC\u0004\u000301\u0002\r!!#\u0002\u001d]\u0014\u0018\u000e^3E_V\u0014G.Z!seR)aN!&\u0003\u0018\"1!\u0011I\u0017A\u0002yCqAa\f.\u0001\u0004\t\t*A\bxe&$XMQ8pY\u0016\fg.\u0011:s)\u0015q'Q\u0014BP\u0011\u0019\u0011\tE\fa\u0001=\"9!q\u0006\u0018A\u0002\u0005e\u0015!E<sSR,G+[7fgR\fW\u000e]!seR)aN!*\u0003(\"1!\u0011I\u0018A\u0002yCqAa\f0\u0001\u0004\t\t/\u0001\u0007xe&$X\rR1uK\u0006\u0013(\u000fF\u0003o\u0005[\u0013y\u000b\u0003\u0004\u0003BA\u0002\rA\u0018\u0005\b\u0005_\u0001\u0004\u0019AAm\u000399(/\u001b;f'R\u0014\u0018N\\4BeJ$RA\u001cB[\u0005oCaA!\u00112\u0001\u0004q\u0006b\u0002B\u0018c\u0001\u0007\u0011\u0011U\u0001\u0013oJLG/\u001a$bgR\u001cFO]5oO\u0006\u0013(\u000fF\u0003o\u0005{\u0013y\f\u0003\u0004\u0003BI\u0002\rA\u0018\u0005\b\u0005_\u0011\u0004\u0019AAQ\u0001")
public class Serializer {
    private final JVMObjectTracker tracker;
    private Tuple2<Function2<DataInputStream, Object, Object>, Function2<DataOutputStream, Object, Object>> sqlSerDe;

    public Tuple2<Function2<DataInputStream, Object, Object>, Function2<DataOutputStream, Object, Object>> sqlSerDe() {
        return this.sqlSerDe;
    }

    public void sqlSerDe_$eq(Tuple2<Function2<DataInputStream, Object, Object>, Function2<DataOutputStream, Object, Object>> x$1) {
        this.sqlSerDe = x$1;
    }

    public void registerSqlSerDe(Tuple2<Function2<DataInputStream, Object, Object>, Function2<DataOutputStream, Object, Object>> sqlSerDe) {
        this.sqlSerDe_$eq(sqlSerDe);
    }

    public char readObjectType(DataInputStream dis) {
        return (char)dis.readByte();
    }

    public Object readObject(DataInputStream dis) {
        char dataType = this.readObjectType(dis);
        return this.readTypedObject(dis, dataType);
    }

    public Object readTypedObject(DataInputStream dis, char dataType) {
        Object object;
        char c = dataType;
        switch (c) {
            case 'n': {
                object = null;
                break;
            }
            case 'i': {
                object = new Integer(this.readInt(dis));
                break;
            }
            case 'd': {
                object = new Double(this.readDouble(dis));
                break;
            }
            case 'b': {
                object = new Boolean(this.readBoolean(dis));
                break;
            }
            case 'c': {
                object = this.readString(dis);
                break;
            }
            case 'e': {
                object = this.readMap(dis);
                break;
            }
            case 'r': {
                object = this.readBytes(dis);
                break;
            }
            case 'a': {
                object = this.readArray(dis);
                break;
            }
            case 'l': {
                object = this.readList(dis);
                break;
            }
            case 'D': {
                object = this.readDate(dis);
                break;
            }
            case 't': {
                object = this.readTime(dis);
                break;
            }
            case 'j': {
                object = this.tracker.getObject(this.readString(dis));
                break;
            }
            default: {
                if (this.sqlSerDe() == null || this.sqlSerDe()._1() == null) {
                    throw new IllegalArgumentException(new StringBuilder(13).append("Invalid type ").append(dataType).toString());
                }
                Object obj = ((Function2)this.sqlSerDe()._1()).apply((Object)dis, (Object)BoxesRunTime.boxToCharacter((char)dataType));
                if (obj == null) {
                    throw new IllegalArgumentException(new StringBuilder(13).append("Invalid type ").append(dataType).toString());
                }
                object = obj;
                break;
            }
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] readBytes(DataInputStream in) {
        void var3_3;
        int len = this.readInt(in);
        byte[] out = new byte[len];
        in.readFully(out);
        BoxedUnit bytesRead = BoxedUnit.UNIT;
        return var3_3;
    }

    public int readInt(DataInputStream in) {
        return in.readInt();
    }

    public double readDouble(DataInputStream in) {
        return in.readDouble();
    }

    public String readStringBytes(DataInputStream in, int len) {
        byte[] bytes = new byte[len];
        in.readFully(bytes);
        if (bytes[len - 1] != 0) {
            throw new IllegalArgumentException("length and stream do not match");
        }
        String str = new String((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).dropRight(1), StandardCharsets.UTF_8);
        return str;
    }

    public String readString(DataInputStream in) {
        int len = in.readInt();
        return this.readStringBytes(in, len);
    }

    public boolean readBoolean(DataInputStream in) {
        int intVal = in.readInt();
        return intVal != 0;
    }

    public Date readDate(DataInputStream in) {
        return Date.valueOf(this.readString(in));
    }

    public Timestamp readTime(DataInputStream in) {
        double seconds = in.readDouble();
        long sec = (long)Math.floor(seconds);
        Timestamp t = new Timestamp(sec * 1000L);
        t.setNanos((int)((seconds - (double)sec) * 1.0E9));
        return t;
    }

    public byte[][] readBytesArr(DataInputStream in) {
        int len = this.readInt(in);
        return (byte[][])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map((Function1 & Serializable & scala.Serializable)x$1 -> this.readBytes(in), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    public int[] readIntArr(DataInputStream in) {
        int len = this.readInt(in);
        return (int[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x$2 -> this.readInt(in), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
    }

    public double[] readDoubleArr(DataInputStream in) {
        int len = this.readInt(in);
        return (double[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$3 -> this.readDouble(in), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
    }

    public boolean[] readBooleanArr(DataInputStream in) {
        int len = this.readInt(in);
        return (boolean[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$4 -> this.readBoolean(in), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Boolean());
    }

    public String[] readStringArr(DataInputStream in) {
        int len = this.readInt(in);
        return (String[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map((Function1 & Serializable & scala.Serializable)x$5 -> this.readString(in), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    public Object readArrayArr(DataInputStream in) {
        int len = this.readInt(in);
        return ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map((Function1 & Serializable & scala.Serializable)x$6 -> this.readArray(in), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Object.class));
    }

    public Object readListArr(DataInputStream in) {
        int len = this.readInt(in);
        return ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map((Function1 & Serializable & scala.Serializable)x$7 -> this.readList(in), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Object.class)));
    }

    public Date[] readDateArr(DataInputStream in) {
        int len = this.readInt(in);
        return (Date[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map((Function1 & Serializable & scala.Serializable)x$8 -> this.readDate(in), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Date.class));
    }

    public Timestamp[] readTimeArr(DataInputStream in) {
        int len = this.readInt(in);
        return (Timestamp[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map((Function1 & Serializable & scala.Serializable)x$9 -> this.readTime(in), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Timestamp.class));
    }

    public Object readArray(DataInputStream dis) {
        Object object;
        char arrType;
        char c = arrType = this.readObjectType(dis);
        switch (c) {
            case 'i': {
                object = this.readIntArr(dis);
                break;
            }
            case 'c': {
                object = this.readStringArr(dis);
                break;
            }
            case 'd': {
                object = this.readDoubleArr(dis);
                break;
            }
            case 'b': {
                object = this.readBooleanArr(dis);
                break;
            }
            case 'j': {
                object = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.readStringArr(dis))).map((Function1 & Serializable & scala.Serializable)x -> $this.tracker.getObject((String)x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Object()));
                break;
            }
            case 'r': {
                object = this.readBytesArr(dis);
                break;
            }
            case 'a': {
                object = this.readArrayArr(dis);
                break;
            }
            case 'l': {
                object = this.readListArr(dis);
                break;
            }
            case 'D': {
                object = this.readDateArr(dis);
                break;
            }
            case 't': {
                object = this.readTimeArr(dis);
                break;
            }
            default: {
                if (this.sqlSerDe() == null || this.sqlSerDe()._1() == null) {
                    throw new IllegalArgumentException(new StringBuilder(19).append("Invalid array type ").append(arrType).toString());
                }
                int len = this.readInt(dis);
                object = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map((Function1 & Serializable & scala.Serializable)x$10 -> Serializer.$anonfun$readArray$2(this, dis, arrType, BoxesRunTime.unboxToInt((Object)x$10)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Object());
                break;
            }
        }
        return object;
    }

    public Object[] readList(DataInputStream dis) {
        int len = this.readInt(dis);
        return (Object[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).map((Function1 & Serializable & scala.Serializable)x$11 -> this.readObject(dis), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Object());
    }

    public scala.collection.immutable.Map<?, ?> readMap(DataInputStream in) {
        scala.collection.immutable.Map map;
        int len = this.readInt(in);
        if (len > 0) {
            Object keys = this.readArray(in);
            Object[] values = this.readList(in);
            map = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps(keys).zip((GenIterable)Predef$.MODULE$.wrapRefArray(values), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        } else {
            map = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        }
        return map;
    }

    public void writeType(DataOutputStream dos, String typeStr) {
        String string = typeStr;
        if ("void".equals(string)) {
            dos.writeByte(110);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("character".equals(string)) {
            dos.writeByte(99);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("double".equals(string)) {
            dos.writeByte(100);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("integer".equals(string)) {
            dos.writeByte(105);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("logical".equals(string)) {
            dos.writeByte(98);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("date".equals(string)) {
            dos.writeByte(68);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("time".equals(string)) {
            dos.writeByte(116);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("raw".equals(string)) {
            dos.writeByte(114);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("array".equals(string)) {
            dos.writeByte(97);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("list".equals(string)) {
            dos.writeByte(108);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("map".equals(string)) {
            dos.writeByte(101);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("jobj".equals(string)) {
            dos.writeByte(106);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("strarray".equals(string)) {
            dos.writeByte(102);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("json".equals(string)) {
            dos.writeByte(74);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("sparkapplybinaryresult".equals(string)) {
            dos.writeByte(36);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new IllegalArgumentException(new StringBuilder(13).append("Invalid type ").append(typeStr).toString());
        }
    }

    private void writeKeyValue(DataOutputStream dos, Object key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("Key in map can't be null.");
        }
        if (!(key instanceof String)) {
            throw new IllegalArgumentException(new StringBuilder(22).append("Invalid map key type: ").append(key.getClass().getName()).toString());
        }
        this.writeString(dos, (String)key);
        this.writeObject(dos, value);
    }

    public void writeObject(DataOutputStream dos, Object obj) {
        if (obj == null) {
            this.writeType(dos, "void");
        } else {
            Object value = obj instanceof WrappedArray ? ((WrappedArray)obj).toArray(ClassTag$.MODULE$.apply(Object.class)) : (obj instanceof Wrappers.SeqWrapper ? ((Wrappers.SeqWrapper)obj).toArray() : obj);
            Object[] objectArray = value;
            if (objectArray instanceof Character) {
                Character c = (Character)objectArray;
                this.writeType(dos, "character");
                this.writeString(dos, c.toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (objectArray instanceof String) {
                String string = (String)objectArray;
                this.writeType(dos, "character");
                this.writeString(dos, string);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (objectArray instanceof Long) {
                Long l = (Long)objectArray;
                this.writeType(dos, "double");
                this.writeDouble(dos, Predef$.MODULE$.Long2long(l));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (objectArray instanceof Float) {
                Float f = (Float)objectArray;
                this.writeType(dos, "double");
                this.writeDouble(dos, Predef$.MODULE$.Float2float(f));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (objectArray instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)objectArray;
                this.writeType(dos, "double");
                this.writeDouble(dos, BigDecimal$.MODULE$.apply(bigDecimal).toDouble());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (objectArray instanceof Double) {
                Double d = (Double)objectArray;
                this.writeType(dos, "double");
                this.writeDouble(dos, Predef$.MODULE$.Double2double(d));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (objectArray instanceof Byte) {
                Byte by = (Byte)objectArray;
                this.writeType(dos, "integer");
                this.writeInt(dos, Predef$.MODULE$.Byte2byte(by));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (objectArray instanceof Short) {
                Short s = (Short)objectArray;
                this.writeType(dos, "integer");
                this.writeInt(dos, Predef$.MODULE$.Short2short(s));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (objectArray instanceof Integer) {
                Integer n = (Integer)objectArray;
                this.writeType(dos, "integer");
                this.writeInt(dos, Predef$.MODULE$.Integer2int(n));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (objectArray instanceof Boolean) {
                Boolean bl = (Boolean)objectArray;
                this.writeType(dos, "logical");
                this.writeBoolean(dos, Predef$.MODULE$.Boolean2boolean(bl));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (objectArray instanceof Date) {
                Date date = (Date)objectArray;
                this.writeType(dos, "date");
                this.writeDate(dos, date);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (objectArray instanceof Time) {
                Time time = (Time)objectArray;
                this.writeType(dos, "time");
                this.writeTime(dos, time);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (objectArray instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)objectArray;
                this.writeType(dos, "time");
                this.writeTime(dos, timestamp);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (objectArray instanceof StructTypeAsJSON) {
                StructTypeAsJSON structTypeAsJSON = (StructTypeAsJSON)objectArray;
                this.writeType(dos, "json");
                this.writeString(dos, structTypeAsJSON.json());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (objectArray instanceof GenericRowWithSchema) {
                GenericRowWithSchema genericRowWithSchema = (GenericRowWithSchema)objectArray;
                this.writeType(dos, "list");
                this.writeInt(dos, genericRowWithSchema.length());
                genericRowWithSchema.toSeq().foreach((Function1 & Serializable & scala.Serializable)elem -> {
                    this.writeObject(dos, elem);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (objectArray instanceof byte[]) {
                byte[] byArray = (byte[])objectArray;
                this.writeType(dos, "raw");
                this.writeBytes(dos, byArray);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (objectArray instanceof char[]) {
                char[] cArray = (char[])objectArray;
                this.writeType(dos, "array");
                this.writeStringArr(dos, (String[])new ArrayOps.ofChar(Predef$.MODULE$.charArrayOps(cArray)).map((Function1 & Serializable & scala.Serializable)x$12 -> Serializer.$anonfun$writeObject$2(BoxesRunTime.unboxToChar((Object)x$12)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (objectArray instanceof short[]) {
                short[] sArray = (short[])objectArray;
                this.writeType(dos, "array");
                this.writeIntArr(dos, (int[])new ArrayOps.ofShort(Predef$.MODULE$.shortArrayOps(sArray)).map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToShort((Object)x$13)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (objectArray instanceof int[]) {
                int[] nArray = (int[])objectArray;
                this.writeType(dos, "array");
                this.writeIntArr(dos, nArray);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (objectArray instanceof long[]) {
                long[] lArray = (long[])objectArray;
                this.writeType(dos, "array");
                this.writeDoubleArr(dos, (double[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(lArray)).map((Function1)(JFunction1.mcDJ.sp & Serializable & scala.Serializable)x$14 -> x$14, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (objectArray instanceof float[]) {
                float[] fArray = (float[])objectArray;
                this.writeType(dos, "array");
                this.writeDoubleArr(dos, (double[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(fArray)).map((Function1)(JFunction1.mcDF.sp & Serializable & scala.Serializable)x$15 -> x$15, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (objectArray instanceof double[]) {
                double[] dArray = (double[])objectArray;
                this.writeType(dos, "array");
                this.writeDoubleArr(dos, dArray);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (objectArray instanceof boolean[]) {
                boolean[] blArray = (boolean[])objectArray;
                this.writeType(dos, "array");
                this.writeBooleanArr(dos, blArray);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (objectArray instanceof Timestamp[]) {
                Timestamp[] timestampArray = (Timestamp[])objectArray;
                this.writeType(dos, "array");
                this.writeTimestampArr(dos, timestampArray);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (objectArray instanceof Date[]) {
                Date[] dateArray = (Date[])objectArray;
                this.writeType(dos, "array");
                this.writeDateArr(dos, dateArray);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (objectArray instanceof String[]) {
                String[] stringArray = (String[])objectArray;
                this.writeType(dos, "strarray");
                this.writeFastStringArr(dos, stringArray);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (objectArray instanceof Object[]) {
                Object[] objectArray2 = objectArray;
                this.writeType(dos, "list");
                this.writeInt(dos, objectArray2.length);
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(objectArray2)).foreach((Function1 & Serializable & scala.Serializable)elem -> {
                    this.writeObject(dos, elem);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (objectArray instanceof Tuple3) {
                Tuple3 tuple3 = (Tuple3)objectArray;
                this.writeType(dos, "list");
                this.writeInt(dos, tuple3.productArity());
                tuple3.productIterator().foreach((Function1 & Serializable & scala.Serializable)elem -> {
                    this.writeObject(dos, elem);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (objectArray instanceof Properties) {
                this.writeType(dos, "jobj");
                this.writeJObj(dos, value);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (objectArray instanceof java.util.Map) {
                java.util.Map map = (java.util.Map)objectArray;
                this.writeType(dos, "map");
                this.writeInt(dos, map.size());
                for (Map.Entry entry : map.entrySet()) {
                    Object key = entry.getKey();
                    Object value2 = entry.getValue();
                    this.writeKeyValue(dos, key, value2);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (objectArray instanceof Map) {
                Map map = (Map)objectArray;
                this.writeType(dos, "map");
                this.writeInt(dos, map.size());
                map.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Serializer.$anonfun$writeObject$8(this, dos, x0$1);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit;
                if (this.sqlSerDe() == null || this.sqlSerDe()._2() == null || !BoxesRunTime.unboxToBoolean((Object)((Function2)this.sqlSerDe()._2()).apply((Object)dos, value))) {
                    this.writeType(dos, "jobj");
                    this.writeJObj(dos, value);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            }
        }
    }

    public void writeInt(DataOutputStream out, int value) {
        out.writeInt(value);
    }

    public void writeDouble(DataOutputStream out, double value) {
        out.writeDouble(value);
    }

    public void writeBoolean(DataOutputStream out, boolean value) {
        int intValue = value ? 1 : 0;
        out.writeInt(intValue);
    }

    public void writeDate(DataOutputStream out, Date value) {
        String string;
        if (value == null) {
            string = "";
        } else {
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
            fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
            string = fmt.format(value);
        }
        this.writeString(out, string);
    }

    public void writeTime(DataOutputStream out, Time value) {
        out.writeDouble(value == null ? Double.NaN : (double)value.getTime() / 1000.0);
    }

    public void writeTime(DataOutputStream out, Timestamp value) {
        out.writeDouble(value == null ? Double.NaN : (double)(value.getTime() / 1000L) + (double)value.getNanos() / 1.0E9);
    }

    public void writeString(DataOutputStream out, String value) {
        byte[] utf8 = value.getBytes(StandardCharsets.UTF_8);
        int len = utf8.length;
        out.writeInt(len);
        out.write(utf8, 0, len);
    }

    public void writeBytes(DataOutputStream out, byte[] value) {
        out.writeInt(value.length);
        out.write(value);
    }

    public void writeJObj(DataOutputStream out, Object value) {
        String objId = this.tracker.put(value);
        this.writeString(out, objId);
    }

    public void writeIntArr(DataOutputStream out, int[] value) {
        this.writeType(out, "integer");
        out.writeInt(value.length);
        new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(value)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)v -> out.writeInt(v));
    }

    public void writeDoubleArr(DataOutputStream out, double[] value) {
        this.writeType(out, "double");
        out.writeInt(value.length);
        new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(value)).foreach((Function1)(JFunction1.mcVD.sp & Serializable & scala.Serializable)v -> out.writeDouble(v));
    }

    public void writeBooleanArr(DataOutputStream out, boolean[] value) {
        this.writeType(out, "logical");
        out.writeInt(value.length);
        new ArrayOps.ofBoolean(Predef$.MODULE$.booleanArrayOps(value)).foreach((Function1 & Serializable & scala.Serializable)v -> {
            this.writeBoolean(out, BoxesRunTime.unboxToBoolean((Object)v));
            return BoxedUnit.UNIT;
        });
    }

    public void writeTimestampArr(DataOutputStream out, Timestamp[] value) {
        this.writeType(out, "time");
        out.writeInt(value.length);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])value)).foreach((Function1 & Serializable & scala.Serializable)v -> {
            this.writeTime(out, v);
            return BoxedUnit.UNIT;
        });
    }

    public void writeDateArr(DataOutputStream out, Date[] value) {
        this.writeType(out, "date");
        out.writeInt(value.length);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])value)).foreach((Function1 & Serializable & scala.Serializable)v -> {
            this.writeDate(out, v);
            return BoxedUnit.UNIT;
        });
    }

    public void writeStringArr(DataOutputStream out, String[] value) {
        this.writeType(out, "character");
        out.writeInt(value.length);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])value)).foreach((Function1 & Serializable & scala.Serializable)v -> {
            this.writeString(out, v);
            return BoxedUnit.UNIT;
        });
    }

    public void writeFastStringArr(DataOutputStream out, String[] value) {
        String all = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])value)).mkString("\u0019");
        this.writeString(out, all);
    }

    public static final /* synthetic */ Object $anonfun$readArray$2(Serializer $this, DataInputStream dis$1, char arrType$1, int x$10) {
        Object obj = ((Function2)$this.sqlSerDe()._1()).apply((Object)dis$1, (Object)BoxesRunTime.boxToCharacter((char)arrType$1));
        if (obj == null) {
            throw new IllegalArgumentException(new StringBuilder(19).append("Invalid array type ").append(arrType$1).toString());
        }
        return obj;
    }

    public static final /* synthetic */ String $anonfun$writeObject$2(char x$12) {
        return ((Object)BoxesRunTime.boxToCharacter((char)x$12)).toString();
    }

    public static final /* synthetic */ void $anonfun$writeObject$8(Serializer $this, DataOutputStream dos$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object key = tuple2._1();
        Object value = tuple2._2();
        $this.writeKeyValue(dos$1, key, value);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public Serializer(JVMObjectTracker tracker) {
        this.tracker = tracker;
    }
}

