% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{jarray}
\alias{jarray}
\title{Instantiate a Java array with a specific element type.}
\usage{
jarray(sc, x, element_type)
}
\arguments{
\item{sc}{A \code{spark_connection}.}

\item{x}{A list of Java object references.}

\item{element_type}{A valid Java class name representing the generic type
parameter of the Java array to be instantiated. Each element of \code{x}
must refer to a Java object that is assignable to \code{element_type}.}
}
\description{
Given a list of Java object references, instantiate an \code{Array[T]}
containing the same list of references, where \code{T} is a non-primitive
type that is more specific than \code{java.lang.Object}.
}
\examples{
sc <- spark_connect(master = "spark://HOST:PORT")

string_arr <- jarray(sc, letters, element_type = "java.lang.String")
# string_arr is now a reference to an array of type String[]

}
