/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.attribute.NominalAttribute;
import org.apache.spark.ml.attribute.NominalAttribute$;
import org.apache.spark.ml.feature.Bucketizer;
import org.apache.spark.ml.feature.QuantileDiscretizerBase;
import org.apache.spark.ml.feature.WeightedQuantileDiscretizer$;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntArrayParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamValidators$;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.param.StringArrayParam;
import org.apache.spark.ml.param.shared.HasHandleInvalid;
import org.apache.spark.ml.param.shared.HasInputCol;
import org.apache.spark.ml.param.shared.HasInputCols;
import org.apache.spark.ml.param.shared.HasOutputCol;
import org.apache.spark.ml.param.shared.HasOutputCols;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import sparklyr.WeightedQuantileSummaries$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001df\u0001\u0002\u000e\u001c\u0005\u0019B\u0001\u0002\u0011\u0001\u0003\u0006\u0004%\t%\u0011\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005\u0005\")\u0001\u000b\u0001C\u0001#\")\u0001\u000b\u0001C\u0001)\"9Q\u000b\u0001b\u0001\n\u000b1\u0006BB.\u0001A\u00035q\u000bC\u0003]\u0001\u0011\u0015Q\fC\u0003c\u0001\u0011\u00051\rC\u0003h\u0001\u0011\u0005\u0001\u000eC\u0003n\u0001\u0011\u0005a\u000eC\u0003q\u0001\u0011\u0005\u0011\u000fC\u0003t\u0001\u0011\u0005A\u000fC\u0003w\u0001\u0011\u0005q\u000fC\u0003z\u0001\u0011\u0005!\u0010\u0003\u0004\u0000\u0001\u0011\u0005\u0011\u0011\u0001\u0005\b\u0003\u000f\u0001A\u0011AA\u0005\u0011\u001d\ti\u0001\u0001C!\u0003\u001fAq!!\n\u0001\t\u0003\n9\u0003C\u0004\u0002N\u0001!I!a\u0014\t\u000f\u0005]\u0003\u0001\"\u0011\u0002Z\u001d9\u0011QM\u000e\t\u0002\u0005\u001ddA\u0002\u000e\u001c\u0011\u0003\tI\u0007\u0003\u0004Q-\u0011\u0005\u0011\u0011\u0012\u0005\b\u0003\u00173B\u0011IAG\u0011%\t\u0019JFA\u0001\n\u0013\t)JA\u000eXK&<\u0007\u000e^3e#V\fg\u000e^5mK\u0012K7o\u0019:fi&TXM\u001d\u0006\u00039u\tqAZ3biV\u0014XM\u0003\u0002\u001f?\u0005\u0011Q\u000e\u001c\u0006\u0003A\u0005\nQa\u001d9be.T!AI\u0012\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0013aA8sO\u000e\u00011#\u0002\u0001(_IR\u0004c\u0001\u0015*W5\tQ$\u0003\u0002+;\tIQi\u001d;j[\u0006$xN\u001d\t\u0003Y5j\u0011aG\u0005\u0003]m\u0011!BQ;dW\u0016$\u0018N_3s!\ta\u0003'\u0003\u000227\t9\u0012+^1oi&dW\rR5tGJ,G/\u001b>fe\n\u000b7/\u001a\t\u0003gaj\u0011\u0001\u000e\u0006\u0003kY\naa\u001d5be\u0016$'BA\u001c\u001e\u0003\u0015\u0001\u0018M]1n\u0013\tIDG\u0001\u0007ICN<V-[4ii\u000e{G\u000e\u0005\u0002<}5\tAH\u0003\u0002>;\u0005!Q\u000f^5m\u0013\tyDHA\u000bEK\u001a\fW\u000f\u001c;QCJ\fWn],sSR\f'\r\\3\u0002\u0007ULG-F\u0001C!\t\u0019EJ\u0004\u0002E\u0015B\u0011Q\tS\u0007\u0002\r*\u0011q)J\u0001\u0007yI|w\u000e\u001e \u000b\u0003%\u000bQa]2bY\u0006L!a\u0013%\u0002\rA\u0013X\rZ3g\u0013\tieJ\u0001\u0004TiJLgn\u001a\u0006\u0003\u0017\"\u000bA!^5eA\u00051A(\u001b8jiz\"\"AU*\u0011\u00051\u0002\u0001\"\u0002!\u0004\u0001\u0004\u0011E#\u0001*\u0002\u001bI,G.\u0019;jm\u0016,%O]8s+\u00059\u0006C\u0001-Z\u001b\u00051\u0014B\u0001.7\u0005-!u.\u001e2mKB\u000b'/Y7\u0002\u001dI,G.\u0019;jm\u0016,%O]8sA\u0005\u0001r-\u001a;SK2\fG/\u001b<f\u000bJ\u0014xN]\u000b\u0002=B\u0011q\fY\u0007\u0002\u0011&\u0011\u0011\r\u0013\u0002\u0007\t>,(\r\\3\u0002!M,GOU3mCRLg/Z#se>\u0014HC\u00013f\u001b\u0005\u0001\u0001\"\u00024\t\u0001\u0004q\u0016!\u0002<bYV,\u0017!D:fi:+XNQ;dW\u0016$8\u000f\u0006\u0002eS\")a-\u0003a\u0001UB\u0011ql[\u0005\u0003Y\"\u00131!\u00138u\u0003-\u0019X\r^%oaV$8i\u001c7\u0015\u0005\u0011|\u0007\"\u00024\u000b\u0001\u0004\u0011\u0015\u0001D:fi>+H\u000f];u\u0007>dGC\u00013s\u0011\u001517\u00021\u0001C\u00031\u0019X\r^,fS\u001eDGoQ8m)\t!W\u000fC\u0003g\u0019\u0001\u0007!)\u0001\ttKRD\u0015M\u001c3mK&sg/\u00197jIR\u0011A\r\u001f\u0005\u0006M6\u0001\rAQ\u0001\u0013g\u0016$h*^7Ck\u000e\\W\r^:BeJ\f\u0017\u0010\u0006\u0002ew\")aM\u0004a\u0001yB\u0019q, 6\n\u0005yD%!B!se\u0006L\u0018\u0001D:fi&s\u0007/\u001e;D_2\u001cHc\u00013\u0002\u0004!1am\u0004a\u0001\u0003\u000b\u00012aX?C\u00035\u0019X\r^(viB,HoQ8mgR\u0019A-a\u0003\t\r\u0019\u0004\u0002\u0019AA\u0003\u0003=!(/\u00198tM>\u0014XnU2iK6\fG\u0003BA\t\u0003C\u0001B!a\u0005\u0002\u001e5\u0011\u0011Q\u0003\u0006\u0005\u0003/\tI\"A\u0003usB,7OC\u0002\u0002\u001c}\t1a]9m\u0013\u0011\ty\"!\u0006\u0003\u0015M#(/^2u)f\u0004X\rC\u0004\u0002$E\u0001\r!!\u0005\u0002\rM\u001c\u0007.Z7b\u0003\r1\u0017\u000e\u001e\u000b\u0004W\u0005%\u0002bBA\u0016%\u0001\u0007\u0011QF\u0001\bI\u0006$\u0018m]3ua\u0011\ty#a\u000f\u0011\r\u0005E\u00121GA\u001c\u001b\t\tI\"\u0003\u0003\u00026\u0005e!a\u0002#bi\u0006\u001cX\r\u001e\t\u0005\u0003s\tY\u0004\u0004\u0001\u0005\u0019\u0005u\u0012\u0011FA\u0001\u0002\u0003\u0015\t!a\u0010\u0003\u0007}#\u0013'\u0005\u0003\u0002B\u0005\u001d\u0003cA0\u0002D%\u0019\u0011Q\t%\u0003\u000f9{G\u000f[5oOB\u0019q,!\u0013\n\u0007\u0005-\u0003JA\u0002B]f\f\u0011cZ3u\t&\u001cH/\u001b8diN\u0003H.\u001b;t)\u0011\t\t&a\u0015\u0011\u0007}kh\fC\u0004\u0002VM\u0001\r!!\u0015\u0002\rM\u0004H.\u001b;t\u0003\u0011\u0019w\u000e]=\u0015\u0007I\u000bY\u0006C\u0004\u0002^Q\u0001\r!a\u0018\u0002\u000b\u0015DHO]1\u0011\u0007a\u000b\t'C\u0002\u0002dY\u0012\u0001\u0002U1sC6l\u0015\r]\u0001\u001c/\u0016Lw\r\u001b;fIF+\u0018M\u001c;jY\u0016$\u0015n]2sKRL'0\u001a:\u0011\u0005122#\u0003\f\u0002l\u0005E\u0014qOAB!\ry\u0016QN\u0005\u0004\u0003_B%AB!osJ+g\r\u0005\u0003<\u0003g\u0012\u0016bAA;y\t)B)\u001a4bk2$\b+\u0019:b[N\u0014V-\u00193bE2,\u0007\u0003BA=\u0003\u007fj!!a\u001f\u000b\u0007\u0005ut$\u0001\u0005j]R,'O\\1m\u0013\u0011\t\t)a\u001f\u0003\u000f1{wmZ5oOB\u0019q,!\"\n\u0007\u0005\u001d\u0005J\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0006\u0002\u0002h\u0005!An\\1e)\r\u0011\u0016q\u0012\u0005\u0007\u0003#C\u0002\u0019\u0001\"\u0002\tA\fG\u000f[\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002\u0018B!\u0011\u0011TAR\u001b\t\tYJ\u0003\u0003\u0002\u001e\u0006}\u0015\u0001\u00027b]\u001eT!!!)\u0002\t)\fg/Y\u0005\u0005\u0003K\u000bYJ\u0001\u0004PE*,7\r\u001e")
public final class WeightedQuantileDiscretizer
extends Estimator<Bucketizer>
implements QuantileDiscretizerBase,
HasWeightCol,
DefaultParamsWritable {
    private final String uid;
    private final DoubleParam relativeError;
    private final Param<String> weightCol;
    private final IntParam numBuckets;
    private final IntArrayParam numBucketsArray;
    private final Param<String> handleInvalid;
    private final StringArrayParam outputCols;
    private final StringArrayParam inputCols;
    private final Param<String> outputCol;
    private final Param<String> inputCol;

    public static WeightedQuantileDiscretizer load(String string) {
        return WeightedQuantileDiscretizer$.MODULE$.load(string);
    }

    public static MLReader<WeightedQuantileDiscretizer> read() {
        return WeightedQuantileDiscretizer$.MODULE$.read();
    }

    public MLWriter write() {
        return DefaultParamsWritable.write$((DefaultParamsWritable)this);
    }

    public void save(String path) throws IOException {
        MLWritable.save$((MLWritable)this, (String)path);
    }

    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$((HasWeightCol)this);
    }

    @Override
    public int getNumBuckets() {
        return QuantileDiscretizerBase.getNumBuckets$(this);
    }

    @Override
    public int[] getNumBucketsArray() {
        return QuantileDiscretizerBase.getNumBucketsArray$(this);
    }

    public final String[] getOutputCols() {
        return HasOutputCols.getOutputCols$((HasOutputCols)this);
    }

    public final String[] getInputCols() {
        return HasInputCols.getInputCols$((HasInputCols)this);
    }

    public final String getOutputCol() {
        return HasOutputCol.getOutputCol$((HasOutputCol)this);
    }

    public final String getInputCol() {
        return HasInputCol.getInputCol$((HasInputCol)this);
    }

    public final String getHandleInvalid() {
        return HasHandleInvalid.getHandleInvalid$((HasHandleInvalid)this);
    }

    public final Param<String> weightCol() {
        return this.weightCol;
    }

    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public IntParam numBuckets() {
        return this.numBuckets;
    }

    @Override
    public IntArrayParam numBucketsArray() {
        return this.numBucketsArray;
    }

    @Override
    public Param<String> handleInvalid() {
        return this.handleInvalid;
    }

    @Override
    public void org$apache$spark$ml$feature$QuantileDiscretizerBase$_setter_$numBuckets_$eq(IntParam x$1) {
        this.numBuckets = x$1;
    }

    @Override
    public void org$apache$spark$ml$feature$QuantileDiscretizerBase$_setter_$numBucketsArray_$eq(IntArrayParam x$1) {
        this.numBucketsArray = x$1;
    }

    @Override
    public void org$apache$spark$ml$feature$QuantileDiscretizerBase$_setter_$handleInvalid_$eq(Param<String> x$1) {
        this.handleInvalid = x$1;
    }

    public final StringArrayParam outputCols() {
        return this.outputCols;
    }

    public final void org$apache$spark$ml$param$shared$HasOutputCols$_setter_$outputCols_$eq(StringArrayParam x$1) {
        this.outputCols = x$1;
    }

    public final StringArrayParam inputCols() {
        return this.inputCols;
    }

    public final void org$apache$spark$ml$param$shared$HasInputCols$_setter_$inputCols_$eq(StringArrayParam x$1) {
        this.inputCols = x$1;
    }

    public final Param<String> outputCol() {
        return this.outputCol;
    }

    public final void org$apache$spark$ml$param$shared$HasOutputCol$_setter_$outputCol_$eq(Param<String> x$1) {
        this.outputCol = x$1;
    }

    public final Param<String> inputCol() {
        return this.inputCol;
    }

    public final void org$apache$spark$ml$param$shared$HasInputCol$_setter_$inputCol_$eq(Param<String> x$1) {
        this.inputCol = x$1;
    }

    public void org$apache$spark$ml$param$shared$HasHandleInvalid$_setter_$handleInvalid_$eq(Param<String> x$1) {
    }

    public String uid() {
        return this.uid;
    }

    public final DoubleParam relativeError() {
        return this.relativeError;
    }

    public final double getRelativeError() {
        return BoxesRunTime.unboxToDouble((Object)this.$((Param)this.relativeError()));
    }

    public WeightedQuantileDiscretizer setRelativeError(double value) {
        return (WeightedQuantileDiscretizer)this.set((Param)this.relativeError(), BoxesRunTime.boxToDouble((double)value));
    }

    public WeightedQuantileDiscretizer setNumBuckets(int value) {
        return (WeightedQuantileDiscretizer)this.set((Param)this.numBuckets(), BoxesRunTime.boxToInteger((int)value));
    }

    public WeightedQuantileDiscretizer setInputCol(String value) {
        return (WeightedQuantileDiscretizer)this.set(this.inputCol(), value);
    }

    public WeightedQuantileDiscretizer setOutputCol(String value) {
        return (WeightedQuantileDiscretizer)this.set(this.outputCol(), value);
    }

    public WeightedQuantileDiscretizer setWeightCol(String value) {
        return (WeightedQuantileDiscretizer)this.set(this.weightCol(), value);
    }

    public WeightedQuantileDiscretizer setHandleInvalid(String value) {
        return (WeightedQuantileDiscretizer)this.set(this.handleInvalid(), value);
    }

    public WeightedQuantileDiscretizer setNumBucketsArray(int[] value) {
        return (WeightedQuantileDiscretizer)this.set((Param)this.numBucketsArray(), value);
    }

    public WeightedQuantileDiscretizer setInputCols(String[] value) {
        return (WeightedQuantileDiscretizer)this.set((Param)this.inputCols(), value);
    }

    public WeightedQuantileDiscretizer setOutputCols(String[] value) {
        return (WeightedQuantileDiscretizer)this.set((Param)this.outputCols(), value);
    }

    public StructType transformSchema(StructType schema) {
        Tuple2 tuple2;
        ParamValidators$.MODULE$.checkSingleVsMultiColumnParams((Params)this, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Param[]{this.outputCol()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StringArrayParam[]{this.outputCols()})));
        if (this.isSet(this.inputCol())) {
            Predef$.MODULE$.require(!this.isSet((Param)this.numBucketsArray()), (Function0 & Serializable & scala.Serializable)() -> "numBucketsArray can't be set for single-column WeightedQuantileDiscretizer.");
        }
        if (this.isSet((Param)this.inputCols())) {
            Predef$.MODULE$.require(this.getInputCols().length == this.getOutputCols().length, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(175).append("WeightedQuantileDiscretizer ").append(this).append(" has mismatched Params ").append("for multi-column transform. Params (inputCols, outputCols) should have ").append("equal lengths, but they have different lengths: ").append("(").append(this.getInputCols().length).append(", ").append(this.getOutputCols().length).append(").").toString());
            if (this.isSet((Param)this.numBucketsArray())) {
                Predef$.MODULE$.require(this.getInputCols().length == this.getNumBucketsArray().length, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(194).append("WeightedQuantileDiscretizer ").append(this).append(" has mismatched Params ").append("for multi-column transform. Params (inputCols, outputCols, numBucketsArray) ").append("should have equal lengths, but they have different lengths: ").append("(").append(this.getInputCols().length).append(", ").append(this.getOutputCols().length).append(", ").append(this.getNumBucketsArray().length).append(").").toString());
                Predef$.MODULE$.require(!this.isSet((Param)this.numBuckets()), (Function0 & Serializable & scala.Serializable)() -> "exactly one of numBuckets, numBucketsArray Params to be set, but both are set.");
            }
        }
        Tuple2 tuple22 = tuple2 = this.isSet((Param)this.inputCols()) ? new Tuple2((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.$((Param)this.inputCols()))).toSeq(), (Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.$((Param)this.outputCols()))).toSeq()) : new Tuple2((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)this.$(this.inputCol())})), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)this.$(this.outputCol())})));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq inputColNames = (Seq)tuple2._1();
        Seq outputColNames = (Seq)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)inputColNames, (Object)outputColNames);
        Tuple2 tuple24 = tuple23;
        Seq inputColNames2 = (Seq)tuple24._1();
        Seq outputColNames2 = (Seq)tuple24._2();
        ObjectRef outputFields = ObjectRef.create((Object)schema.fields());
        ((IterableLike)inputColNames2.zip((GenIterable)outputColNames2, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            WeightedQuantileDiscretizer.$anonfun$transformSchema$5(schema, outputFields, x0$1);
            return BoxedUnit.UNIT;
        });
        return new StructType((StructField[])outputFields.elem);
    }

    public Bucketizer fit(Dataset<?> dataset) {
        Bucketizer bucketizer;
        this.transformSchema(dataset.schema(), true);
        Bucketizer bucketizer2 = new Bucketizer(this.uid()).setHandleInvalid((String)this.$(this.handleInvalid()));
        if (this.isSet((Param)this.inputCols())) {
            double[][] dArray;
            if (this.isSet((Param)this.numBucketsArray())) {
                double[][] probArrayPerCol = (double[][])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])this.$((Param)this.numBucketsArray()))).map((Function1 & Serializable & scala.Serializable)numOfBuckets -> WeightedQuantileDiscretizer.$anonfun$fit$1(BoxesRunTime.unboxToInt((Object)numOfBuckets)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))));
                double[] probabilityArray = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])probArrayPerCol)).flatten((Function1 & Serializable & scala.Serializable)xs -> Predef$.MODULE$.wrapDoubleArray(xs), ClassTag$.MODULE$.Double()))).sorted((Ordering)Ordering.Double$.MODULE$))).distinct();
                double[][] splitsArrayRaw = WeightedQuantileSummaries$.MODULE$.approxWeightedQuantile((Dataset<Row>)dataset.toDF(), (String[])this.$((Param)this.inputCols()), (String)this.$(this.weightCol()), probabilityArray, BoxesRunTime.unboxToDouble((Object)this.$((Param)this.relativeError())));
                dArray = (double[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])splitsArrayRaw)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])probArrayPerCol), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    double[] splits = (double[])tuple2._1();
                    double[] probs = (double[])tuple2._2();
                    Set probSet = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(probs)).toSet();
                    Set idxSet = new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(probabilityArray)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).collect((PartialFunction)new scala.Serializable(null, probSet){
                        public static final long serialVersionUID = 0L;
                        private final Set probSet$1;

                        /*
                         * Enabled aggressive block sorting
                         */
                        public final <A1 extends Tuple2<Object, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            Object object;
                            A1 A1 = x1;
                            if (A1 != null) {
                                double p = A1._1$mcD$sp();
                                int idx = A1._2$mcI$sp();
                                if (this.probSet$1.apply((Object)BoxesRunTime.boxToDouble((double)p))) {
                                    object = BoxesRunTime.boxToInteger((int)idx);
                                    return (B1)object;
                                }
                            }
                            object = function1.apply(x1);
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(Tuple2<Object, Object> x1) {
                            double p;
                            Tuple2<Object, Object> tuple2 = x1;
                            boolean bl = tuple2 != null && this.probSet$1.apply((Object)BoxesRunTime.boxToDouble((double)(p = tuple2._1$mcD$sp())));
                            return bl;
                        }
                        {
                            this.probSet$1 = probSet$1;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).toSet();
                    double[] dArray = (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(splits)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).collect((PartialFunction)new scala.Serializable(null, idxSet){
                        public static final long serialVersionUID = 0L;
                        private final Set idxSet$1;

                        /*
                         * Enabled aggressive block sorting
                         */
                        public final <A1 extends Tuple2<Object, Object>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                            Object object;
                            A1 A1 = x2;
                            if (A1 != null) {
                                double s = A1._1$mcD$sp();
                                int idx = A1._2$mcI$sp();
                                if (this.idxSet$1.apply((Object)BoxesRunTime.boxToInteger((int)idx))) {
                                    object = BoxesRunTime.boxToDouble((double)s);
                                    return (B1)object;
                                }
                            }
                            object = function1.apply(x2);
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(Tuple2<Object, Object> x2) {
                            int idx;
                            Tuple2<Object, Object> tuple2 = x2;
                            boolean bl = tuple2 != null && this.idxSet$1.apply((Object)BoxesRunTime.boxToInteger((int)(idx = tuple2._2$mcI$sp())));
                            return bl;
                        }
                        {
                            this.idxSet$1 = idxSet$1;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                    return dArray;
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))));
            } else {
                dArray = WeightedQuantileSummaries$.MODULE$.approxWeightedQuantile((Dataset<Row>)dataset.toDF(), (String[])this.$((Param)this.inputCols()), (String)this.$(this.weightCol()), (double[])((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), BoxesRunTime.unboxToInt((Object)this.$((Param)this.numBuckets()))).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$3 -> (double)x$3 / (double)BoxesRunTime.unboxToInt((Object)this.$((Param)this.numBuckets())), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double()), BoxesRunTime.unboxToDouble((Object)this.$((Param)this.relativeError())));
            }
            double[][] splitsArray = dArray;
            bucketizer = bucketizer2.setSplitsArray((double[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])splitsArray)).map((Function1 & Serializable & scala.Serializable)splits -> this.getDistinctSplits((double[])splits), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)))));
        } else {
            double[][] splits2 = WeightedQuantileSummaries$.MODULE$.approxWeightedQuantile((Dataset<Row>)dataset.toDF(), (String[])((Object[])new String[]{(String)this.$(this.inputCol())}), (String)this.$(this.weightCol()), (double[])((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), BoxesRunTime.unboxToInt((Object)this.$((Param)this.numBuckets()))).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$4 -> (double)x$4 / (double)BoxesRunTime.unboxToInt((Object)this.$((Param)this.numBuckets())), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double()), BoxesRunTime.unboxToDouble((Object)this.$((Param)this.relativeError())));
            bucketizer = bucketizer2.setSplits(this.getDistinctSplits(splits2[0]));
        }
        return (Bucketizer)this.copyValues((Params)bucketizer2.setParent((Estimator)this), this.copyValues$default$2());
    }

    private double[] getDistinctSplits(double[] splits) {
        splits[0] = Double.NEGATIVE_INFINITY;
        splits[splits.length - 1] = Double.POSITIVE_INFINITY;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), splits.length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            block0: {
                if (splits[i] != -0.0) break block0;
                splits$1[i] = 0.0;
            }
        });
        double[] distinctSplits = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(splits)).distinct();
        if (splits.length != distinctSplits.length) {
            this.log().warn(new StringBuilder(65).append("Some quantiles were identical. Bucketing to ").append(distinctSplits.length - 1).append(" buckets as a result.").toString());
        }
        return (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(distinctSplits)).sorted((Ordering)Ordering.Double$.MODULE$);
    }

    public WeightedQuantileDiscretizer copy(ParamMap extra) {
        return (WeightedQuantileDiscretizer)this.defaultCopy(extra);
    }

    public static final /* synthetic */ void $anonfun$transformSchema$5(StructType schema$1, ObjectRef outputFields$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String inputColName = (String)tuple2._1();
        String outputColName = (String)tuple2._2();
        SchemaUtils$.MODULE$.checkNumericType(schema$1, inputColName, SchemaUtils$.MODULE$.checkNumericType$default$3());
        Predef$.MODULE$.require(!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema$1.fieldNames())).contains((Object)outputColName), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Output column ").append(outputColName).append(" already exists.").toString());
        NominalAttribute attr = NominalAttribute$.MODULE$.defaultAttr().withName(outputColName);
        outputFields$1.elem = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((StructField[])outputFields$1.elem))).$colon$plus((Object)attr.toStructField(), ClassTag$.MODULE$.apply(StructField.class));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ double[] $anonfun$fit$1(int numOfBuckets) {
        return (double[])((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), numOfBuckets).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x$2 -> (double)x$2 / (double)numOfBuckets, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
    }

    public WeightedQuantileDiscretizer(String uid) {
        this.uid = uid;
        HasHandleInvalid.$init$((HasHandleInvalid)this);
        HasInputCol.$init$((HasInputCol)this);
        HasOutputCol.$init$((HasOutputCol)this);
        HasInputCols.$init$((HasInputCols)this);
        HasOutputCols.$init$((HasOutputCols)this);
        QuantileDiscretizerBase.$init$(this);
        HasWeightCol.$init$((HasWeightCol)this);
        MLWritable.$init$((MLWritable)this);
        DefaultParamsWritable.$init$((DefaultParamsWritable)this);
        this.relativeError = new DoubleParam((Identifiable)this, "relativeError", "the relative target precision for the approximate quantile algorithm. Must be in the range [0, 1]", ParamValidators$.MODULE$.inRange(0.0, 1.0));
        this.setDefault((Param)this.relativeError(), BoxesRunTime.boxToDouble((double)0.001));
    }

    public WeightedQuantileDiscretizer() {
        this(Identifiable$.MODULE$.randomUID("weightedQuantileDiscretizer"));
    }
}

