% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stream_view.R
\name{stream_stats}
\alias{stream_stats}
\title{Stream Statistics}
\usage{
stream_stats(stream, stats = list())
}
\arguments{
\item{stream}{The stream to collect statistics from.}

\item{stats}{An optional stats object generated using \code{stream_stats()}.}
}
\value{
A stats object containing streaming statistics that can be passed
  back to the \code{stats} parameter to continue aggregating streaming stats.
}
\description{
Collects streaming statistics, usually, to be used with \code{stream_render()}
to render streaming statistics.
}
\examples{
\dontrun{
sc <- spark_connect(master = "local")
sdf_len(sc, 10) \%>\%
  spark_write_parquet(path = "parquet-in")

stream <- stream_read_parquet(sc, "parquet-in") \%>\%
  stream_write_parquet("parquet-out")

stream_stats(stream)
}

}
