% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{pathfinder}
\alias{pathfinder}
\title{The pathfinder network}
\format{A \code{\link{list}} with four components:

\itemize{
\item \code{dag} An \code{\link[sparsebnUtils]{edgeList}} containing the pathfinder network (109 nodes, 195 edges).
\item \code{data} A \code{\link{data.frame}} with 109 variables and 1000 observations.
\item \code{ivn} A \code{\link{list}} specifying which nodes are under intervention in each observation; since this dataset
is purely observational, this is just \code{NULL}. Compatible with the input to \code{\link[sparsebnUtils]{sparsebnData}}.
\item \code{cov} Covariance matrix used to generate the data.
}}
\usage{
data(pathfinder)
}
\description{
Simulated data and network for the pathfinder network from the
\href{https://www.bnlearn.com/bnrepository/}{Bayesian network repository}.
Pathfinder is an expert system developed by
\href{http://heckerman.com/david/HN92cbr.pdf}{Heckerman et. al (1992)} [1]
to assist with the diagnosis of lymph-node diseases.
}
\details{
This is a benchmark network used to test algorithms for learning Bayesian
networks. The data is simulated from a Gaussian SEM assuming unit edge weights and
unit variances for all nodes.
}
\examples{

### Create a valid sparsebnData object from the simulated pathfinder data
data(pathfinder)
dat <- sparsebnData(pathfinder$data, type = "c")

### Code to reproduce this dataset by randomly generating edge weights
coefs <- runif(n = num.edges(pathfinder$dag), min = 0.5, max = 2) # coefficients
vars <- rep(1, num.nodes(pathfinder$dag))                         # variances
params <- c(coefs, vars)                                          # parameter vector
pathfinder.data <- generate_mvn_data(graph = pathfinder$dag,
                                     params = params,
                                     n = 1000)

}
\references{
[1] Heckerman, David E., and Bharat N. Nathwani. "\href{http://heckerman.com/david/HN92cbr.pdf}{An evaluation of the diagnostic accuracy of Pathfinder}." Computers and Biomedical Research 25.1 (1992): 56-74.
}
\keyword{datasets}
