% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lda-schafer.r
\name{lda_schafer}
\alias{lda_schafer}
\alias{lda_schafer.default}
\alias{lda_schafer.formula}
\alias{predict.lda_schafer}
\title{Linear Discriminant Analysis using the Schafer-Strimmer Covariance Matrix
Estimator}
\usage{
lda_schafer(x, ...)

\method{lda_schafer}{default}(x, y, prior = NULL, ...)

\method{lda_schafer}{formula}(formula, data, prior = NULL, ...)

\method{predict}{lda_schafer}(object, newdata, ...)
}
\arguments{
\item{x}{matrix containing the training data. The rows are the sample
observations, and the columns are the features.}

\item{...}{additional arguments passed to
\code{\link[corpcor]{invcov.shrink}}}

\item{y}{vector of class labels for each training observation}

\item{prior}{vector with prior probabilities for each class. If NULL
(default), then equal probabilities are used. See details.}

\item{formula}{A formula of the form \code{groups ~ x1 + x2 + ...} That is,
the response is the grouping factor and the right hand side specifies the
(non-factor) discriminators.}

\item{data}{data frame from which variables specified in \code{formula} are
preferentially to be taken.}

\item{object}{trained lda_schafer object}

\item{newdata}{matrix of observations to predict. Each row corresponds to a
new observation.}
}
\value{
\code{lda_schafer} object that contains the trained classifier

list predicted class memberships of each row in newdata
}
\description{
Given a set of training data, this function builds the Linear Discriminant
Analysis (LDA) classifier, where the distributions of each class are assumed
to be multivariate normal and share a common covariance matrix. When the
pooled sample covariance matrix is singular, the linear discriminant function
is incalculable. This function replaces the inverse of pooled sample
covariance matrix with an estimator proposed by Schafer and Strimmer
(2005). The estimator is calculated via \code{\link[corpcor]{invcov.shrink}}.

The Linear Discriminant Analysis (LDA) classifier involves the assumption
that the distributions of each class are assumed to be multivariate normal
and share a common covariance matrix. When the pooled sample covariance
matrix is singular, the linear discriminant function is incalculable. Here,
the inverse of the pooled sample covariance matrix is replaced with an
estimator from Schafer and Strimmer (2005).
}
\details{
The matrix of training observations are given in \code{x}. The rows of \code{x}
contain the sample observations, and the columns contain the features for each
training observation.

The vector of class labels given in \code{y} are coerced to a \code{factor}.
The length of \code{y} should match the number of rows in \code{x}.

An error is thrown if a given class has less than 2 observations because the
variance for each feature within a class cannot be estimated with less than 2
observations.

The vector, \code{prior}, contains the \emph{a priori} class membership for
each class. If \code{prior} is NULL (default), the class membership
probabilities are estimated as the sample proportion of observations belonging
to each class. Otherwise, \code{prior} should be a vector with the same length
as the number of classes in \code{y}. The \code{prior} probabilties should be
nonnegative and sum to one.
}
\examples{
n <- nrow(iris)
train <- sample(seq_len(n), n / 2)
lda_schafer_out <- lda_schafer(Species ~ ., data = iris[train, ])
predicted <- predict(lda_schafer_out, iris[-train, -5])$class

lda_schafer_out2 <- lda_schafer(x = iris[train, -5], y = iris[train, 5])
predicted2 <- predict(lda_schafer_out2, iris[-train, -5])$class
all.equal(predicted, predicted2)
}
\references{
Schafer, J., and Strimmer, K. (2005). "A shrinkage approach to
large-scale covariance estimation and implications for functional genomics,"
Statist. Appl. Genet. Mol. Biol. 4, 32.

Schafer, J., and Strimmer, K. (2005). "A shrinkage approach to
large-scale covariance estimation and implications for functional genomics,"
Statist. Appl. Genet. Mol. Biol. 4, 32.
}

