\name{diag_estimates}
\alias{diag_estimates}
\title{Computes estimates and ancillary information for diagonal classifiers}
\usage{
diag_estimates(x, y, prior = NULL, pool = FALSE, est_mean = c("mle",
  "tong"))
}
\arguments{
  \item{x}{matrix containing the training data. The rows
  are the sample observations, and the columns are the
  features.}

  \item{y}{vector of class labels for each training
  observation}

  \item{prior}{vector with prior probabilities for each
  class. If NULL (default), then equal probabilities are
  used. See details.}

  \item{pool}{logical value. If TRUE, calculates the pooled
  sample variances for each class.}

  \item{est_mean}{the estimator for the class means. By
  default, we use the maximum likelihood estimator (MLE).
  To improve the estimation, we provide the option to use a
  shrunken mean estimator proposed by Tong et al. (2012).}
}
\value{
named list with estimators for each class and necessary
ancillary information
}
\description{
Computes the maximum likelihood estimators (MLEs) for each
class under the assumption of multivariate normality for
each class. Also, computes ancillary information necessary
for classifier summary, such as sample size, the number of
features, etc.
}
\details{
This function computes the common estimates and ancillary
information used in all of the diagonal classifiers in the
\code{sparsediscrim} package.

The matrix of training observations are given in \code{x}.
The rows of \code{x} contain the sample observations, and
the columns contain the features for each training
observation.

The vector of class labels given in \code{y} are coerced to
a \code{factor}. The length of \code{y} should match the
number of rows in \code{x}.

An error is thrown if a given class has less than 2
observations because the variance for each feature within a
class cannot be estimated with less than 2 observations.

The vector, \code{prior}, contains the \emph{a priori}
class membership for each class. If \code{prior} is NULL
(default), the class membership probabilities are estimated
as the sample proportion of observations belonging to each
class. Otherwise, \code{prior} should be a vector with the
same length as the number of classes in \code{y}. The
\code{prior} probabilties should be nonnegative and sum to
one.
}
\references{
Tong, T., Chen, L., and Zhao, H. (2012), "Improved Mean
Estimation and Its Application to Diagonal Discriminant
Analysis," Bioinformatics, 28, 4, 531-537.
\url{http://bioinformatics.oxfordjournals.org/content/28/4/531.long}
}

