\name{risk_stein}
\alias{risk_stein}
\title{Stein Risk function from Pang et al. (2009).}
\usage{
risk_stein(N, K, var_feature, num_alphas = 101, t = -1)
}
\arguments{
  \item{N}{the sample size.}

  \item{K}{the number of classes.}

  \item{var_feature}{a vector of the sample variances for
  each dimension.}

  \item{num_alphas}{The number of values used to find the
  optimal amount of shrinkage.}

  \item{t}{a constant specified by the user that indicates
  the exponent to use with the variance estimator. By
  default, t = -1 as in Pang et al. See the paper for more
  details.}
}
\value{
list with \itemize{ \item \code{alpha}: the alpha that
minimizes the average risk under a Stein loss function. If
the minimum is not unique, we randomly select an
\code{alpha} from the minimizers.  \item \code{risk}: the
minimum average risk attained. }
}
\description{
This function finds the value for \eqn{alpha \in [0,1]}
that empirically minimizes the average risk under a Stein
loss function, which is given on page 1023 of Pang et al.
(2009).
}
\references{
Pang, H., Tong, T., & Zhao, H. (2009). "Shrinkage-based
Diagonal Discriminant Analysis and Its Applications in
High-Dimensional Data," Biometrics, 65, 4, 1021-1029.
\url{http://onlinelibrary.wiley.com/doi/10.1111/j.1541-0420.2009.01200.x/abstract}
}

