% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitVECM.R
\name{fitVECM}
\alias{fitVECM}
\title{Multivariate VECM estimation}
\usage{
fitVECM(data, p, penalty, method, logScale, ...)
}
\arguments{
\item{data}{the data from the time series: variables in columns and observations in 
rows}

\item{p}{order of the VECM model}

\item{penalty}{the penalty function to use. Possible values are \code{"ENET"}, 
\code{"SCAD"} or \code{"MCP"}}

\item{method}{\code{"cv"} or \code{"timeSlice"}}

\item{logScale}{should the function consider the \code{log} of the inputs? By default
this is set to \code{TRUE}}

\item{...}{options for the function (TODO: specify)}
}
\value{
Pi the matrix \code{Pi} for the VECM model

G the list (of length \code{p-1}) of the estimated matrices of the process

fit the results of the penalized LS estimation

mse the mean square error of the cross validation

time elapsed time for the estimation
}
\description{
A function to estimate a (possibly big) multivariate VECM time series
using penalized least squares methods, such as ENET, SCAD or MC+.
}

