% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type-predicates.R
\name{type-predicates}
\alias{type-predicates}
\alias{is_sparse_vector}
\alias{is_sparse_numeric}
\alias{is_sparse_double}
\alias{is_sparse_integer}
\alias{is_sparse_character}
\alias{is_sparse_logical}
\title{Sparse vector type checkers}
\usage{
is_sparse_vector(x)

is_sparse_numeric(x)

is_sparse_double(x)

is_sparse_integer(x)

is_sparse_character(x)

is_sparse_logical(x)
}
\arguments{
\item{x}{value to be checked.}
}
\value{
single logical value
}
\description{
Helper functions to determine whether an vector is a sparse vector or not.
}
\details{
\code{is_sparse_vector()} is a general function that detects any type of sparse
vector created with this package. \code{is_sparse_double()},
\code{is_sparse_integer()}, \code{is_sparse_character()}, and \code{is_sparse_logical()} are
more specific functions that only detects the type. \code{is_sparse_numeric()}
matches both sparse integers and doubles.
}
\examples{
x_sparse <- sparse_double(c(pi, 5, 0.1), c(2, 5, 10), 10)
x_dense <- c(0, pi, 0, 0, 0.5, 0, 0, 0, 0, 0.1)

is_sparse_vector(x_sparse)
is_sparse_vector(x_dense)

is_sparse_double(x_sparse)
is_sparse_double(x_dense)

is_sparse_character(x_sparse)
is_sparse_character(x_dense)

# Forced materialization
is_sparse_vector(x_sparse[])
}
