\name{Technique 3: Latin-Hypercube: Perform Analysis of Results}
\alias{lhc_process_sample_run_subsets}
\alias{lhc_generateLHCSummary}
\alias{lhc_generatePRCoEffs}
\alias{lhc_graphMeasuresForParameterChange}
\title{LHC: Perform Analysis of Results}
\description{Though Technique 2 does elucidate the effects of perturbations of one parameter, it cannot show any non-linear effects which occur when two or more are adjusted simultaneously. Thus we have included this method described by Read et al, Saltelli et al, and others (Reference's below). The technique above provides the means to sample the parameter space using a latin hypercube approach, and this technique allows for the analysis of simulation results generated using these parameter sets. For each parameter set generated, n simulation runs should have been performed (with n established using Technique 1 - Aleatory Analysis). The algorithm takes each parameter set in turn, processing the simulation results to generate median values for each output measure over the n runs. A summary file is then created, containing all parameter value sets that were created in sampling alongside these calculated median results. An example of such a file can be seen in the data directory of this package (LHCSummary.csv). With this summary complete, each parameter being analysed is processed in turn, to determine if there are any correlations between the value of this parameter and simulation output result, although all other parameter values are being perturbed.  Partial Rank Correlation Coefficients are generated for each output measure, for each parameter. These give a statistical indication of any correlations that have now become apparent. An example of this can again be seen in the data directory (corCoeffs.csv). To ease identification of such effects, graphs are produced for each parameter, showing the parameter value against the simulation result (output measure).\cr
\cr
\bold{Note:} The package expects that the results to be analysed are within a set folder structure. For an explanation of what this structure should be, see figure LHC_Folder_Struc.png in the extdata folder within this package, or the tutorial available on the project website./cr
\cr
There are four methods available:\cr
\bold{lhc_process_sample_run_subsets:} Takes each parameter value set generated by the hypercube in turn, and analyses the simulation results.  For each parameter set, there will be n simulation results. This method goes through these results, producing a file containing the median of each output measure for each of the n runs. Thus, if n=300, the median file will contain 300 medians for each simulation output measure.\cr
\bold{lhc_generateLHCSummary:} This method goes through each parameter value set generated by the hypercube and calculates the median of each output measure, from those in the median output measure from each run calculated above. Thus for each parameter value set, we go from n medians for each measure to 1.  A summary file is produced, containing the parameter values in that set alongside the median of each output measure when the simulation is run under these conditions.  An example of this file can be seen in the data folder of this package (EgSet_LHC_Summary.csv).\cr
\bold{lhc_generatePRCoEffs:} For each parameter, and each simulation output measure, calculates the Partial Rank Correlation Coefficient between the parameter value and the simulation results, giving a statistical measurement of any effect that is present.  This is output to a CSV file, an example of which can be seen in the data folder of this package (EgSet_LHC_corCoeffs.csv)\cr
\bold{lhc_graphMeasuresForParameterChange:} Produces a graph for each parameter, and each output measure, showing the simulation output achieved when that parameter was assigned that value.  Eases identification of any non-linear effects. Two examples can be seen in the extdata folder (LHC_maxVCAMeffectProbabilityCutoff_Velocity.pdf and LHC_chemoThreshold_Velocity.pdf).
}  
\usage{
lhc_process_sample_run_subsets(FILEPATH,NUMSAMPLES,
	NUMRUNSPERSAMPLE,MEASURES,RESULTFILEFORMAT,
	RESULTFILENAME,ALTERNATIVEFILENAME,OUTPUTCOLSTART,
	OUTPUTCOLEND,MEDIANSFILEFORMAT,MEDIANSFILENAME)

lhc_generateLHCSummary(FILEPATH,LHC_PARAM_CSV_LOCATION,
	PARAMETERS,NUMSAMPLES,MEASURES,MEDIANSFILEFORMAT,
	MEDIANSFILENAME,LHCSUMMARYFILENAME)

lhc_generatePRCoEffs(FILEPATH,PARAMETERS,MEASURES,
	LHCSUMMARYFILENAME,CORCOEFFSOUTPUTFILE)

lhc_graphMeasuresForParameterChange(FILEPATH,PARAMETERS,
	MEASURES,MEASURE_SCALE,CORCOEFFSOUTPUTFILE,
	LHCSUMMARYFILENAME,TIMEPOINT,TIMEPOINTSCALE)
}
\arguments{
  \item{FILEPATH}{Directory where the simulation runs can be found}
  \item{NUMSAMPLES}{The number of parameter subsets that were generated in the LHC design}
  \item{NUMRUNSPERSAMPLE}{The number of runs performed for each parameter subset. This figure is generated through Aleatory Analysis}
  \item{MEASURES}{Array containing the names of the output measures which are used to analyse the simulation}
  \item{RESULTFILEFORMAT}{The file format output by the simulation. Spartan can process XML or CSV output formats}
  \item{RESULTFILENAME}{Name of the simulation results file (e.g. "trackedCells_Close")}
  \item{ALTERNATIVEFILENAME}{In some cases, it may be relevant to read from a further results file if the initial file contains no results. This filename is set here}
  \item{OUTPUTCOLSTART}{Column number in the results file where output begins - saves (a) reading in unnecessary data, and (b) errors where the first column is a label, and therefore could contain duplicates}
  \item{OUTPUTCOLEND}{Column number in the results file where the last output measure is}
  \item{MEDIANSFILEFORMAT}{File format for the median distribution files produced from simulation results. Can be either XML or CSV}
  \item{LHC_PARAM_CSV_LOCATION}{Location of the file output by the latin-hypercube sampling method}
  \item{MEDIANSFILENAME}{Analyses the results of replicate simulation runs and creates a file containing the median value of each measure for every run. This specifies what that file should be called (e.g. Medians)}
  \item{PARAMETERS}{Array containing the names of the parameters of which parameter samples will be generated}
  \item{LHCSUMMARYFILENAME}{Name of the LHC Summary file to be generated by lhc_generateLHCSummary. Contains each parameter set alongside the result gained when the simulation was run under that criteria. Example - LHC_Summary}
  \item{CORCOEFFSOUTPUTFILE}{Name of the file to be generated by lhc_generatePRCoEffs.  Contains the Partial Rank Correlation Coefficients for each parameter.  Example - CorCoEffs}
  \item{MEASURE_SCALE}{An array containing the measure used for each of the output measures (i.e. microns, microns/min).  Used to label graphs}
  \item{TIMEPOINT}{Used so this method can be used when analysing multiple simulation timepoints.  NULL in this case.  See Technique 3: LHC Analysis Over Time}
  \item{TIMEPOINTSCALE}{Used so this method can be used when analysing multiple simulation timepoints.  NULL in this case.  See Technique 1: LHC Analysis Over Time}
}
\references{This technique is described by Read et al (2011) in their paper: Techniques for Grounding Agent-Based Simulations in the Real Domain: a case study in Experimental Autoimmune Encephalomyelitis", and also in the Saltelli et al book: "Senstivity Analysis". Code to perform Partial Rank Correlation Coeffient has been downloaded from http://www.yilab.gatech.edu/pcor.R}
\examples{
# THE CODE IN THIS EXAMPLE IS THE SAME AS THAT USED IN THE TUTORIAL, AND
# THUS YOU NEED TO DOWNLOAD THE TUTORIAL DATA SET AND SET FILEPATH
# CORRECTLY TO RUN THIS

##--Firstly, declare the parameters required for the 4 functions--
# A - DIRECTORY WHERE THE BATCH RUN SAMPLE SETS HAVE BEEN STORED
FILEPATH<-"/media/FreeAgent/package_Test_Data/LHC/LHC_Results/"
# B: AN ARRAY OF THE PARAMETERS WHICH HAVE BEEN PERTURBED OR ARE
# BEING ANALYSED
PARAMETERS <- c("thresholdBindProbability","chemoThreshold",
"chemoUpperLinearAdjust","chemoLowerLinearAdjust",
"maxVCAMeffectProbabilityCutoff","vcamSlope")
# C- OUTPUT MEASURES
MEASURES<-c("Velocity","Displacement")
# D - MEASURES USED FOR EACH OF THE ABOVE - FOR GRAPHING PURPOSES
MEASURE_SCALE<-c("Microns/Min","Microns")
# E: THE NUMBER OF TIMES THE SPACE HAS BEEN SAMPLED
NUMSAMPLES <- 500
# F: THE NUMBER OF TIMES THE SIMULATION HAS BEEN RUN FOR EACH
# PARAMETER SET
NUMRUNSPERSAMPLE<-300
# G: FORMAT OF THE SIMULATOR RESULT FILES
RESULTFILEFORMAT<-"csv"
# H: WHAT THE SIMULATION RESULT FILE IS CALLED
RESULTFILENAME<-"trackedCells_Close_Endpoint"
# I: NAME OF AN ALTERNATIVE RESULTS FILE IF NECESSARY
ALTERNATIVEFILENAME<-NULL
# J: WHERE THE OUTPUT MEASURES START IN THE RESULTS FILE FROM THE
# SIMULATION. SAVES READING THE WHOLE FILE & AVOIDS POTENTIAL
# PROBLEMS WHERE THE FIRST COLUMN IS DUPLICATED (eg A CELL LABEL)
OUTPUTCOLSTART<-10
# K: WHERE THE OUTPUT MEASURES END
OUTPUTCOLEND<-11
# L: FILE FORMAT FOR THE MEDIAN OUTPUT FILE - XML OR CSV
MEDIANSFILEFORMAT<-"csv"
# M: NAME TO CALL THE FILE CONTAINING THE MEDIANS OF EACH RUN FOR A
# PARAMETER VALUE SET
MEDIANSFILENAME<-"EgSet_Medians"
# N: NAME AND LOCATION OF A CSV FILE CONTAINING THE VALUES OF THE 
# PARAMETERS # BEING ANALYSED (AS PRODUCED BY POTENTIALLY THE SAMPLING
# METHOD IN TECHNIQUE 3
LHC_PARAM_CSV_LOCATION<-"/media/FreeAgent/package_Test_Data/LHC/
	LHC_Results/LHC_Parameters_for_Runs.csv"
# O: NAME OF THE LHC SUMMARY FILE NAME PRODUCED, CONTAINING THE 
# PARAMETER VALUES AND THE MEDIAN RESULTS GENERATED BY SIMULATION RUNS
LHCSUMMARYFILENAME<-"EgSet_LHCSummary"
# P: FILENAME TO GIVE THE FILE CONTAINING THE PARTIAL RANK CORRELATION
# COEFFICIENTS THAT ARE GENERATED
CORCOEFFSOUTPUTFILE<-"EgSet_corCoeffs"
# Q: TIMEPOINT AND TIMEPOINTSCALE ONLY USED FOR MULTIPLE TIMEPOINTS
# - NOT USED HERE
TIMEPOINT<-NULL
TIMEPOINTSCALE<-NULL

\dontrun{
# DONTRUN IS SET SO THIS IS NOT EXECUTED WHEN PACKAGE IS COMPILED - BUT THIS
# HAS BEEN TESTED WITH THE TUTORIAL DATA

##--- NOW RUN THE FOUR METHODS IN THIS ORDER ----
# A - GENERATE THE MEDIANS FOR EACH SET OF PARAMETER VALUES
# GENERATED BY THE HYPERCUBE
lhc_process_sample_run_subsets(FILEPATH,NUMSAMPLES,
	NUMRUNSPERSAMPLE,MEASURES,RESULTFILEFORMAT,
	RESULTFILENAME,ALTERNATIVEFILENAME,OUTPUTCOLSTART,
	OUTPUTCOLEND,MEDIANSFILEFORMAT,MEDIANSFILENAME)

# B - GENERATE THE SUMMARY FILE SHOWING THE PARAMETERS USED AND
# MEDIAN RESULTS FOR THE MEASURES OVER THE n RUNS
# THIS PRODUCES LHCSUMMARY.CSV - THEREFORE IF JUST REANALYSING
# TURN THIS OFF
lhc_generateLHCSummary(FILEPATH,LHC_PARAM_CSV_LOCATION,
	PARAMETERS,NUMSAMPLES,MEASURES,MEDIANSFILEFORMAT,
	MEDIANSFILENAME,LHCSUMMARYFILENAME)

# C- CALCULATE THE PARTIAL RANK CORRELATION COEFFICIENTS
lhc_generatePRCoEffs(FILEPATH,PARAMETERS,MEASURES,
	LHCSUMMARYFILENAME,CORCOEFFSOUTPUTFILE)

# D - GRAPH THE RESULTS
lhc_graphMeasuresForParameterChange(FILEPATH,PARAMETERS,
	MEASURES,MEASURE_SCALE,CORCOEFFSOUTPUTFILE,
	LHCSUMMARYFILENAME,TIMEPOINT,TIMEPOINTSCALE)
}

}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{latin}
\keyword{hypercube}
\keyword{parameter}
\keyword{analysis}
