oat_csv_result_file_analysis<-function(FILEPATH,CSV_FILE_NAME,PARAMETERS,BASELINE,MEASURES,ATESTRESULTFILENAME,PMIN=NULL,PMAX=NULL,PINC=NULL,PARAMVALS=NULL,TIMEPOINTS=NULL,TIMEPOINTSCALE=NULL)
{
	if(is.null(TIMEPOINTS))
	{

		# NEW TO SPARTAN VERSION 2
		# READS SIMULATION RESPONSES FROM A CSV FILE, IN THE FORMAT: PARAMETER VALUES (COLUMNS), SIMULATION OUTPUT MEASURES
		# IN A CHANGE TO SPARTAN 1, THE FIRST FUNCTION THAT PROCESSES SIMULATION RESPONSES CREATES THIS FILE, NOT MEDIANS FOR EACH PARAMETER AS IT USED TO 
		# THIS WAY WE ARE NOT DEALING WITH TWO METHODS OF SIMULATION RESULT SPECIFICATION
		# READ IN THE OAT RESULT FILE
		RESULT<-read.csv(paste(FILEPATH,"/",CSV_FILE_NAME,sep=""),sep=",",header=T)

		# FIRSTLY FILTER THE SIMULATION RESULTS WHEN AT BASELINE VALUES
		BASELINE_RESULT<-subset_results_by_param_value_set(PARAMETERS,RESULT,BASELINE)

		# STORE ALL THE A-TEST SCORES FOR ALL EXPERIMENTS
		ALL_ATEST_SCORES<-NULL

		# DO THE BASELINE A-TEST FIRST - THIS WILL ALWAYS BE NO DIFFERENCE, BUT NEEDS TO BE LISTED AS A RESULT FOR GRAPHING
		# THIS ALSO STOPS THE SAME TEST BEING DONE FOR EACH PARAMETER (AS EACH WILL BE AT BASELINE VALUE AT SOME POINT)
		ALL_ATEST_SCORES<-rbind(ALL_ATEST_SCORES,perform_aTest_for_all_sim_measures(BASELINE, BASELINE_RESULT,BASELINE_RESULT,MEASURES))

		# NOW PROCESS EACH PARAMETER
		for(PARAM in 1:length(PARAMETERS))
		{
			# THE RESULTS OF THE OAT ANALYSIS IS IN ONE PLACE. THUS WE NEED TO REFER TO THE CORRECT BASELINE RESULT FOR PARAMETERS THAT ARE
			# NOT BEING CHANGED SO WE USE THE VARIABLE EXP_PARAMS WHEN WE START A NEW VARIABLE - WE SET THE PARAMS TO THE BASELINE AND THEN ONLY
			# ALTER THE ONE BEING CHANGED
			EXP_PARAMS<-as.character(BASELINE)
		
			# NOW GET THE LIST OF PARAMETER VALUES BEING EXPLORED FOR THIS PARAMETER
			# NOTE THE CONVERSION BACK TO NUMBERS - GETS RID OF TRAILING ZEROS MADE BY SEQ
			PARAM_VAL_LIST<-as.numeric(prepare_parameter_value_list(PMIN,PMAX,PINC,PARAMVALS,PARAM))

			# NOW WE ITERATE THROUGH THE VALUES IN THIS LIST
			for(PARAMVAL in 1:length(PARAM_VAL_LIST))
			{
				print(paste("Processing Parameter: ",PARAMETERS[PARAM]," Value: ",PARAM_VAL_LIST[PARAMVAL],sep=""))

				# HERE WE STOP THE CASE OF THE BASELINE BEING PROCESSED SEVERAL TIMES, AS IT WOULD BE FOR EACH PARAMETER
				if(PARAM_VAL_LIST[PARAMVAL]!=BASELINE[PARAM])
				{
					# SET THE VALUE OF THIS PARAMETER TO BE THAT WE ARE PROCESSING
					EXP_PARAMS[PARAM] <- as.character(PARAM_VAL_LIST[PARAMVAL])

					PARAM_RESULT<-subset_results_by_param_value_set(PARAMETERS,RESULT,EXP_PARAMS)

					# NOW WE CAN COMPARE THIS BEHAVIOUR TO THAT AT THE BASELINE USING THE A-TEST. DO THIS FOR EACH MEASURE
					ALL_ATEST_SCORES<-rbind(ALL_ATEST_SCORES,perform_aTest_for_all_sim_measures(EXP_PARAMS, BASELINE_RESULT,PARAM_RESULT,MEASURES))
				}
			}	
		}

		# LABEL THE SCORES
		LABELS<-NULL
		for(MEASURE in 1:length(MEASURES))
		{
			LABELS<-cbind(LABELS,paste("ATest",MEASURES[MEASURE],sep=""),paste("ATest",MEASURES[MEASURE],"Norm",sep=""))
		}

		colnames(ALL_ATEST_SCORES)<-cbind(t(PARAMETERS),LABELS)

		# WRITE THE FILE OUT
		RESULTSFILE = paste(FILEPATH,"/",ATESTRESULTFILENAME,sep="")

		write.csv(ALL_ATEST_SCORES,RESULTSFILE,quote = FALSE,row.names=FALSE)
	}
	else
	{
		# PROCESS EACH TIMEPOINT, BY AMENDING THE FILENAMES AND RECALLING THIS FUNCTION
		for(n in 1:length(TIMEPOINTS))
		{

			TIMEPOINTPROCESSING<-TIMEPOINTS[n]
			print(paste("PROCESSING TIMEPOINT: ",TIMEPOINTPROCESSING,sep=""))
			
			CSV_FILE_NAME_FORMAT<-substr(CSV_FILE_NAME,(nchar(CSV_FILE_NAME)+1)-3,nchar(CSV_FILE_NAME))
			CSV_FILE_NAME_FULL<-paste(substr(CSV_FILE_NAME,0,nchar(CSV_FILE_NAME)-4),"_",TIMEPOINTPROCESSING,".",CSV_FILE_NAME_FORMAT,sep="")

			ATESTRESULTFILENAME_FORMAT<-substr(ATESTRESULTFILENAME,(nchar(ATESTRESULTFILENAME)+1)-3,nchar(ATESTRESULTFILENAME))
			ATESTRESULTFILENAME_FULL<-paste(substr(ATESTRESULTFILENAME,0,nchar(ATESTRESULTFILENAME)-4),"_",TIMEPOINTPROCESSING,".",ATESTRESULTFILENAME_FORMAT,sep="")
			
			
			oat_csv_result_file_analysis(FILEPATH,CSV_FILE_NAME_FULL,PARAMETERS,BASELINE,MEASURES,ATESTRESULTFILENAME_FULL,PMIN,PMAX,
							PINC,PARAMVALS,TIMEPOINTS=NULL,TIMEPOINTSCALE=NULL)


		}
	}
}
