prepare_parameter_value_list<-function(PMIN,PMAX,PINC,PARAMVALS,PARAM_OF_INT)
{
	# WHEN ITERATING THROUGH PARAMETER VALUES, WE NEED TO DO A BIT OF PREP AS THERE ARE TWO WAYS THESE VALUES CAN BE SPECIFIED 
	# (INCREMENT AND SPECIFIED IN A LIST). THIS RETURNS A LIST OF THE VALUES FOR BOTH SPECIFICATIONS SO THESE CAN BE ITERATED THROUGH
	
	if(is.null(PARAMVALS))
	{
		# MUST HAVE SPECIFIED AS MIN, MAX, AND INC
		PARAM_VAL_LIST<-seq(PMIN[PARAM_OF_INT],PMAX[PARAM_OF_INT],PINC[PARAM_OF_INT])

		# BUT WE ADDED A CHECK HERE - DUE TO POTENTIAL OF ROUNDING ERRORS IN SEQ, THE VALUE MAY NOT MATCH THE PARAMETER IN THE OUTPUT
		# SO ROUND THE VALUE TO THE NUMBER OF DECIMAL PLACES IN THE INCREMENT
		for(i in 1:length(PARAM_VAL_LIST))
		{
			dp<-num.decimals(PINC[PARAM_OF_INT])
			PARAM_VAL_LIST[i]<-round(PARAM_VAL_LIST[i],digits=dp+2)
		}
		# Convert to char - stops any trailing zeros that may lead to results not being found
		PARAM_VAL_LIST<-as.character(PARAM_VAL_LIST)
	}
	else
	{
		# WILL HAVE SPECIFIED A STRING LIST OF VALUES, SPLIT AND CONVERT TO NUMBERS
		PARAM_VAL_LIST<-strsplit(PARAMVALS[PARAM_OF_INT],",")[[1]]
	}

	# NOTE THE RETURN AS CHARACTER - STOPS ANY TRAILING ZEROS WHICH MAY MAKE THE RESULTS IMPOSSIBLE TO FIND IN THE OUTPUT FILE
	return(PARAM_VAL_LIST)
}


