% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efast_analysis.R
\name{generate_sensitivity_indices}
\alias{generate_sensitivity_indices}
\title{Generate eFAST Sensitivity Indices}
\usage{
generate_sensitivity_indices(results_array, omi, MI, MEASURES, PARAMETERS,
  NUMCURVES)
}
\arguments{
\item{results_array}{Results for all eFAST resample curves}

\item{omi}{floor( ( (wanted_n / NUMCURVES) - 1) / (2 * MI) / length(PARAMETERS))}

\item{MI}{maximum number of fourier coefficients, always 4}

\item{MEASURES}{Array containing the names of the output measures which
are used to analyse the simulation}

\item{PARAMETERS}{Array containing the names of the parameters of which
parameter samples have been generated}

\item{NUMCURVES}{The number of 'resamples' to perform (see eFAST
documentation) - recommend using at least 3}
}
\value{
List of SI and STI coefficients and error bars
}
\description{
Generate eFAST Sensitivity Indices
}
