% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dunit_measure.R
\name{dunit_measure}
\alias{dunit_measure}
\alias{dunit_measure-spatPomp}
\alias{dunit_measure,spatPomp-method}
\title{dunit_measure
\code{dunit_measure} evaluates the unit measurement density of a unit's observation given the entire state}
\usage{
\S4method{dunit_measure}{spatPomp}(object, y, x, unit, time, params, log = TRUE, ...)
}
\arguments{
\item{object}{An object of class \code{spatPomp}}

\item{y}{A U by 1 matrix of observations for all units}

\item{x}{A state vector for all units}

\item{unit}{The unit for which to evaluate the unit measurement density}

\item{time}{The time for which to evaluate the unit measurement density}

\item{params}{parameters at which to evaluate the unit measurement density}

\item{log}{logical; should the density be returned on log scale?}

\item{\dots}{additional arguments will be ignored}
}
\value{
A class \sQuote{matrix} with the unit measurement density for spatial unit \code{unit}
corresponding to the corresponding measurement in \code{y} and states in \code{x}.
}
\description{
dunit_measure
\code{dunit_measure} evaluates the unit measurement density of a unit's observation given the entire state
}
\examples{
b <- bm(U=3)
s <- states(b)[,1,drop=FALSE]
rownames(s) -> rn
dim(s) <- c(3,1,1)
dimnames(s) <- list(variable=rn, rep=NULL)
p <- coef(b); names(p) -> rnp
dim(p) <- c(length(p),1); dimnames(p) <- list(param=rnp)
o <- obs(b)[,1,drop=FALSE]
dunit_measure(b, y=o, x=s, unit=1, time=1, params=p)

}
