% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vec_dmeasure.R
\name{vec_dmeasure}
\alias{vec_dmeasure}
\alias{vec_dmeasure-spatPomp}
\alias{vec_dmeasure,spatPomp-method}
\title{Vector of unit measurement densities for each unit}
\usage{
\S4method{vec_dmeasure}{spatPomp}(object, y, x, units, times, params, log = FALSE, ...)
}
\arguments{
\item{object}{a \code{spatPomp} object}

\item{y}{numeric; measurements whose densities given the latent states are evaluated}

\item{x}{numeric; state at which conditional measurement densities are evaluated}

\item{units}{numeric; units at which measurement densities are evaluated}

\item{times}{numeric; time at which measurement densities are evaluated}

\item{params}{numeric; parameter set at which measurement densities is evaluated}

\item{log}{logical; should the outputted measurement densities be on log scale?}

\item{\dots}{additional parameters will be ignored}
}
\value{
An array of dimension \code{length(unit_names(object))} by \code{dim(x)[2]} by \code{dim(x)[3]}
representing each unit's measurement density assessed for each replicate in \code{x} for each observation time.
}
\description{
Evaluate the unit measurement model density function for each unit.
This method is used primarily as part of likelihood evaluation and parameter inference algorithms.
}
\author{
Kidus Asfaw
}
