% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_spatgeom.R
\name{plot_alpha_shape}
\alias{plot_alpha_shape}
\title{Plot alpha-shape for \code{spatgeom} objects}
\usage{
plot_alpha_shape(x, alpha, font_size = 12)
}
\arguments{
\item{x}{an object of class \code{spatgeom}.}

\item{alpha}{value of \code{alpha} determining the maximum length between
points to build the alpha-shape.}

\item{font_size}{a integer that increases the font size in the plot.}
}
\value{
a \code{\link[ggplot2]{ggplot}} object with the raw alpha-shape for
the original data at resolution \code{alpha}
}
\description{
Plot alpha-shape for \code{spatgeom} objects.
}
\examples{
n <- 30
a <- -1
b <- 1
theta <- runif(n, 0, 2 * pi)
r <- (sqrt(runif(n))) * (0.5) + 0.5
X1 <- r * cos(theta)
X2 <- runif(n, a, b)
Y <- data.frame(Y = r * sin(theta))
X <- data.frame(X1, X2)

estimation <- spatgeom(y = Y, x = X)

plot_alpha_shape(estimation, alpha = c(0.9, 1.2))
}
