% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outliers.R
\name{outliers}
\alias{outliers}
\title{Outliers}
\usage{
outliers(x, s = 1.4826)
}
\arguments{
\item{x}{A numeric vector}

\item{s}{Scaling factor for mad statistic}
}
\value{
value for the modified Z-score
}
\description{
Identify outliers using modified Z-score
}
\examples{
 # Create data with 3 outliers
    x <- seq(0.1, 5, length=100) 
    x[98:100] <- c(100, 55, 250)
 
 # Calculate Z score
     Z <- outliers(x) 
 
 # Show number of extreme outliers using Z-score
     length(Z[Z > 9.9])
 
 # Remove extreme outliers 
     x <- x[-which(Z > 9.9)]

}
\references{
Iglewicz, B. & D.C. Hoaglin (1993) How to Detect and Handle Outliers, American Society for Quality Control, Milwaukee, WI.
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
