% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/land.metrics.R
\name{land.metrics}
\alias{land.metrics}
\title{Landscape metrics for points and polygons}
\usage{
land.metrics(...)
}
\arguments{
\item{...}{Parameters to be passed to the modern version 
of the function}
}
\description{
Calculates a variety of landscape metrics, on 
             binary rasters, for polygons or points with a 
             buffer distance
}
\examples{
\dontrun{
library(landscapemetrics)
library(raster)

data(landscape)
points <- matrix(c(10, 5, 25, 15, 5, 25), 
                 ncol = 2, byrow = TRUE)

sample_lsm(landscape, y = points, size = 10, 
           level = "landscape", type = "diversity metric", 
           classes_max = 3,
           verbose = FALSE)
}	   
}
