% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kendall.R
\name{kendall}
\alias{kendall}
\title{Kendall tau trend with continuity correction for time-series}
\usage{
kendall(
  y,
  tau = TRUE,
  intercept = TRUE,
  p.value = TRUE,
  z.value = TRUE,
  confidence = TRUE,
  prewhiten = FALSE,
  na.rm,
  ...
)
}
\arguments{
\item{y}{A vector representing a timeseries with >= 8 obs}

\item{tau}{(FALSE/TRUE) return tau values}

\item{intercept}{(FALSE/TRUE) return intercept values}

\item{p.value}{(FALSE/TRUE) return p.values}

\item{z.value}{(FALSE/TRUE) return z values}

\item{confidence}{(FALSE/TRUE) return 95 pct confidence levels}

\item{prewhiten}{(FALSE/TRUE) Apply autocorrelation correction using
pre-whitening}

\item{na.rm}{(FALSE/TRUE) Remove NA values}

\item{...}{Not used}
}
\value{
Depending on arguments, a vector containing:
\itemize{
\item Theil-Sen slope, always returned
\item Kendall's tau two-sided test, if tau TRUE
\item intercept for trend if intercept TRUE, not
if prewhitened
\item p value for trend fit if p.value TRUE
\item Z value for trend fit if z.value TRUE
\item lower confidence level at 95-pct if confidence
TRUE, not if prewhitened
\item upper confidence level at 95-pct if confidence
TRUE, not if prewhitened
}
}
\description{
Calculates a nonparametric statistic for a monotonic trend based
on the Kendall tau statistic and the Theil-Sen slope modification
}
\details{
This function implements Kendall's nonparametric test for a monotonic trend
using the Theil-Sen (Theil 1950; Sen 1968; Siegel 1982) method to estimate
the slope and related confidence intervals. Critical values are Z > 1.96
representing a significant increasing trend and a Z < -1.96 a significant
decreasing trend (p < 0.05). The null hypothesis can be rejected if Tau = 0.
There is also an option for autocorrelation correction using the method proposed
in Yue & Wang (2002).
}
\examples{
\donttest{
data(EuStockMarkets)
d <- as.vector(EuStockMarkets[,1])
kendall(d)
} 
}
\references{
Theil, H. (1950) A rank invariant method for linear and polynomial regression
analysis. Nederl. Akad. Wetensch. Proc. Ser. A 53:386-392 (Part I),
53:521-525 (Part II), 53:1397-1412 (Part III).

Sen, P.K. (1968) Estimates of Regression Coefficient Based on Kendall's tau.
Journal of the American Statistical Association. 63(324):1379-1389.

Siegel, A.F. (1982) Robust Regression Using Repeated Medians.
Biometrika, 69(1):242-244

Yue, S., & Wang, C. Y. (2002). Applicability of prewhitening to eliminate
the influence of serial correlation on the Mann-Kendall test. Water
Resources Research, 38(6):41-47.
}
\author{
Jeffrey S. Evans  \href{mailto:jeffrey_evans@tnc.org}{jeffrey_evans@tnc.org}
}
